/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts.matcher;

import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class ConsistencyMatcher<T>
extends BaseMatcher<T> {
    private final T value;
    private final Matcher<? super T> matcher;
    private final Matcher<? super T> actualMatcher;

    public ConsistencyMatcher(T value, Matcher<? super T> matcher) {
        this.value = value;
        this.matcher = Objects.requireNonNull(matcher, "Delegate matcher cannot be null!");
        this.actualMatcher = matcher.matches(value) ? matcher : Matchers.not(matcher);
    }

    public T getValue() {
        return this.value;
    }

    public Matcher<? super T> getMatcher() {
        return this.matcher;
    }

    public boolean matches(Object item) {
        return this.actualMatcher.matches(item);
    }

    public void describeTo(Description description) {
        this.actualMatcher.describeTo(description);
        description.appendValueList(", just like <", "", ">", new Object[]{this.getValue()});
    }
}

