/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts.matcher;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class FunctionalMatcher<T>
extends BaseMatcher<T> {
    private final Class<? super T> type;
    private final Predicate<T> predicate;
    private final Consumer<Description> describer;

    public FunctionalMatcher(Class<? super T> type, Predicate<T> predicate, String description) {
        this(type, predicate, (Description d) -> d.appendText(description));
    }

    public FunctionalMatcher(Class<? super T> type, Predicate<T> predicate, Consumer<Description> describer) {
        this.type = Objects.requireNonNull(type, "type");
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.describer = Objects.requireNonNull(describer, "describer");
    }

    public Class<? super T> getType() {
        return this.type;
    }

    public Predicate<T> getPredicate() {
        return this.predicate;
    }

    public Consumer<Description> getDescriber() {
        return this.describer;
    }

    public boolean matches(Object item) {
        return (item == null || this.getType().isInstance(item)) && this.getPredicate().test(item);
    }

    public void describeTo(Description description) {
        this.getDescriber().accept(description);
    }
}

