/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.asserts.matcher;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.whaka.asserts.AssertResult;
import org.whaka.asserts.matcher.ResultProvidingMatcher;

public class ThrowableMatcher
extends ResultProvidingMatcher<Throwable> {
    private static final ThrowableMatcher NOT_EXPECTED = new ThrowableMatcher(null);
    private final Class<? extends Throwable> expectedType;

    private ThrowableMatcher(Class<? extends Throwable> expectedType) {
        this.expectedType = expectedType;
    }

    public Class<? extends Throwable> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public Optional<AssertResult> matches(Throwable item, String message, Throwable cause) {
        if (this.getExpectedType() == null ? item == null : this.getExpectedType().isInstance(item)) {
            return Optional.empty();
        }
        Class actual = Optional.ofNullable(item).map(Object::getClass).orElse(null);
        if (cause == null) {
            cause = item;
        }
        return Optional.of(new AssertResult(actual, this.getExpectedMessage(), message, cause));
    }

    public void describeTo(Description description) {
        description.appendText(this.getExpectedMessage());
    }

    private String getExpectedMessage() {
        return this.getExpectedType() == null ? "no exception" : "instance of " + this.getExpectedType().getCanonicalName();
    }

    @Factory
    public static ThrowableMatcher throwableOfType(Class<? extends Throwable> type) {
        return type == null ? NOT_EXPECTED : new ThrowableMatcher(type);
    }

    @Factory
    public static ThrowableMatcher notExpected() {
        return NOT_EXPECTED;
    }
}

