/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.whaka.data.ColumnKey;

public final class Column<T> {
    public final ColumnKey<T> key;
    public final List<T> data;

    @SafeVarargs
    public Column(ColumnKey<T> key, T ... data) {
        this(key, (Collection<T>)Arrays.asList(data));
    }

    public Column(ColumnKey<T> key, Collection<T> data) {
        this.key = Objects.requireNonNull(key, "Column key cannot be null!");
        this.data = data == null || data.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(data));
    }

    @SafeVarargs
    public static <A> Column<A> create(Class<A> type, A ... data) {
        return Column.create(type, Arrays.asList(data));
    }

    public static <A> Column<A> create(Class<A> type, Collection<A> data) {
        return new Column<A>(new ColumnKey<A>(type), data);
    }

    public Class<T> getType() {
        return this.key.type;
    }

    public ColumnKey<T> getKey() {
        return this.key;
    }

    public List<T> getData() {
        return this.data;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.getKey()).addValue(this.getData()).toString();
    }
}

