/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.whaka.data.Column;
import org.whaka.data.ColumnKey;
import org.whaka.util.UberStreams;
import org.whaka.util.function.UberStream;

public final class Columns
implements Iterable<Column<?>> {
    public final List<Column<?>> columns;

    public Columns(Column<?> ... columns) {
        this(Arrays.asList(columns));
    }

    public Columns(Collection<Column<?>> columns) {
        if (columns == null || columns.isEmpty()) {
            this.columns = Collections.emptyList();
        } else {
            Preconditions.checkArgument((!columns.contains(null) ? 1 : 0) != 0, (Object)"Column cannot be null!");
            long distinctKeys = ((UberStream)((UberStream)UberStreams.stream(columns).map(Column::getKey)).distinct()).count();
            Preconditions.checkArgument(((long)columns.size() == distinctKeys ? 1 : 0) != 0, (Object)"Keys duplication in the columns!");
            this.columns = Collections.unmodifiableList(new ArrayList(columns));
        }
    }

    public boolean isPresent(ColumnKey<?> key) {
        return UberStreams.stream(this.columns).anyMatch(Columns.keyMatcher(key));
    }

    public <T> Column<T> getColumn(ColumnKey<T> key) {
        return UberStreams.stream(this.columns).find(Columns.keyMatcher(key)).orElse(null);
    }

    private static Predicate<Column<?>> keyMatcher(ColumnKey<?> key) {
        return column -> column.getKey() == key;
    }

    public List<Column<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public Iterator<Column<?>> iterator() {
        return this.getColumns().iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.columns).toString();
    }
}

