/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.whaka.data.Column;
import org.whaka.data.ColumnKey;
import org.whaka.data.Columns;
import org.whaka.util.UberStreams;

public final class ColumnsBuilder {
    private List<Column<?>> columns = new ArrayList();

    public boolean isPresent(ColumnKey<?> key) {
        return UberStreams.stream(this.getColumns()).anyMatch(ColumnsBuilder.keyMatcher(key));
    }

    public <T> Column<T> getColumn(ColumnKey<T> key) {
        return UberStreams.stream(this.getColumns()).find(ColumnsBuilder.keyMatcher(key)).orElse(null);
    }

    private static Predicate<Column<?>> keyMatcher(ColumnKey<?> key) {
        return column -> column.getKey() == key;
    }

    public List<Column<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public <T> ColumnsBuilder addColumn(ColumnKey<T> key, T ... data) {
        return this.addColumn(key, (Collection<T>)Arrays.asList(data));
    }

    public <T> ColumnsBuilder addColumn(ColumnKey<T> key, Collection<T> data) {
        return this.addColumn(new Column<T>(key, data));
    }

    public ColumnsBuilder addColumn(Column<?> column) {
        return this.addColumn(column, this.getColumns().size());
    }

    public ColumnsBuilder addColumn(Column<?> column, int idx) {
        ColumnKey<?> key = column.getKey();
        if (this.isPresent(key)) {
            throw new IllegalArgumentException("Column with specified key is already present: " + this.getColumn(key));
        }
        this.columns.add(idx, column);
        return this;
    }

    public <T> Column<T> removeColumn(ColumnKey<T> key) {
        Column<T> column = this.getColumn(key);
        this.columns.remove(column);
        return column;
    }

    public Columns build() {
        return new Columns(this.getColumns());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.getColumns()).toString();
    }
}

