/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.whaka.util.UberStreams;

public class NullStrategy {
    public static NullStrategy NO_STRATEGY = new NullStrategy(ArrayList::new);
    public static NullStrategy NULLABLE_START = new NullStrategy(NullStrategy::nullableStart);
    public static NullStrategy NULLABLE_END = new NullStrategy(NullStrategy::nullableEnd);
    private final Function<Collection, List> function;

    private NullStrategy(Function<Collection, List> function) {
        this.function = function;
    }

    public <T> T[] apply(T[] arr) {
        return UberStreams.stream(this.apply(Arrays.asList(arr))).toArray(arr.getClass().getComponentType());
    }

    public <T> List<T> apply(Collection<T> col) {
        return this.function.apply(col);
    }

    public static <T> List<T> nullableStart(Collection<T> col) {
        ArrayList<T> list = new ArrayList<T>(col);
        if (list.isEmpty() || list.get(0) != null) {
            list.add(0, null);
        }
        return list;
    }

    public static <T> List<T> nullableEnd(Collection<T> col) {
        ArrayList<T> list = new ArrayList<T>(col);
        if (list.isEmpty() || list.get(list.size() - 1) != null) {
            list.add(null);
        }
        return list;
    }
}

