/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.whaka.data.ColumnKey;
import org.whaka.data.RowEntry;
import org.whaka.util.UberStreams;
import org.whaka.util.function.UberStream;

public final class Row
implements Iterable<RowEntry<?>> {
    public final List<RowEntry<?>> entries;

    public Row(Collection<RowEntry<?>> entries) {
        Preconditions.checkArgument((entries != null && !entries.isEmpty() ? 1 : 0) != 0, (Object)"Row data cannot be null or empty!");
        Preconditions.checkArgument((!entries.contains(null) ? 1 : 0) != 0, (Object)"Row data cannot contain null values!");
        long distinctKeys = ((UberStream)((UberStream)UberStreams.stream(entries).map(RowEntry::getKey)).distinct()).count();
        Preconditions.checkArgument(((long)entries.size() == distinctKeys ? 1 : 0) != 0, (Object)"Keys duplication in the row data!");
        this.entries = Collections.unmodifiableList(new ArrayList(entries));
    }

    public boolean isPresent(ColumnKey<?> key) {
        return UberStreams.stream(this.entries).anyMatch(Row.keyMatcher(key));
    }

    public <T> T getValue(ColumnKey<T> key) {
        return (T)UberStreams.stream(this.entries).find(Row.keyMatcher(key)).orElseThrow(() -> new NoSuchElementException("No such column: " + key)).getValue();
    }

    private static Predicate<RowEntry<?>> keyMatcher(ColumnKey<?> key) {
        return value -> value.getKey() == key;
    }

    public List<RowEntry<?>> getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<RowEntry<?>> iterator() {
        return this.entries.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.entries).toString();
    }
}

