/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data.shuffle;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.whaka.data.Column;
import org.whaka.data.Columns;
import org.whaka.data.Row;
import org.whaka.data.RowEntry;
import org.whaka.data.Rows;
import org.whaka.data.shuffle.Shuffle;
import org.whaka.util.UberStreams;
import org.whaka.util.function.UberStream;

public class IndexShuffle
implements Shuffle {
    private final Function<int[], int[][]> indexCalculator;

    public IndexShuffle(Function<int[], int[][]> indexCalculator) {
        this.indexCalculator = Objects.requireNonNull(indexCalculator, "Index calculator function cannot be null!");
    }

    public Function<int[], int[][]> getIndexCalculator() {
        return this.indexCalculator;
    }

    @Override
    public Rows apply(Columns cols) {
        Preconditions.checkArgument((!cols.getColumns().isEmpty() ? 1 : 0) != 0, (Object)"Cannot shuffle empty columns!");
        int[] columnSizes = ((UberStream)UberStreams.stream(cols).map(Column::getData)).mapToInt(List::size).toArray();
        int[][] rowsIndexes = this.indexCalculator.apply(columnSizes);
        List<Row> rows = ((UberStream)UberStreams.stream(rowsIndexes).map(arr -> IndexShuffle.createRow(arr, cols))).toList();
        return new Rows(rows);
    }

    private static Row createRow(int[] rowIndexes, Columns cols) {
        ArrayList data = new ArrayList();
        for (int i = 0; i < rowIndexes.length; ++i) {
            if (rowIndexes[i] < 0) continue;
            Column<?> col = cols.getColumns().get(i);
            Object value = col.getData().get(rowIndexes[i]);
            data.add(new RowEntry(col.getKey(), value));
        }
        return new Row(data);
    }
}

