/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.data.shuffle.pairwise;

import com.google.common.primitives.Booleans;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.whaka.data.shuffle.AbstractRowCollector;

class HashRowCollector
extends AbstractRowCollector {
    private final LinkedList<long[]> hashes = new LinkedList();
    private final AtomicBoolean cleanUpRequired = new AtomicBoolean();

    HashRowCollector() {
    }

    @Override
    public boolean isValidRow(int[] row) {
        return row.length < 3 || HashRowCollector.isUniqueHashPresent(HashRowCollector.createHash(row), this.hashes);
    }

    @Override
    public boolean addRowIfValid(int[] row) {
        if (row.length < 3) {
            this.rows.add(row);
            return true;
        }
        long[] hash = HashRowCollector.createHash(row);
        if (HashRowCollector.isUniqueHashPresent(hash, this.hashes)) {
            this.rows.add(row);
            this.hashes.add(hash);
            this.cleanUpRequired.set(true);
            return true;
        }
        return false;
    }

    @Override
    public List<int[]> getRows() {
        if (this.cleanUpRequired.compareAndSet(true, false)) {
            CleanUp.FULL_CLEAN_UP.performCleanUp(this);
        }
        return super.getRows();
    }

    private static boolean isUniqueHashPresent(long[] hash, List<long[]> hashes) {
        boolean[] matches = new boolean[hash.length];
        for (long[] next : hashes) {
            if (next == hash) continue;
            for (int i = 0; i < hash.length; ++i) {
                if (matches[i]) continue;
                matches[i] = hash[i] == next[i];
            }
            if (Booleans.contains((boolean[])matches, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private static long[] createHash(int[] row) {
        long[] hash = new long[HashRowCollector.countPairs(row.length)];
        int index = 0;
        for (int a = 0; a < row.length - 1; ++a) {
            for (int b = a + 1; b < row.length; ++b) {
                hash[index++] = HashRowCollector.combine(row[a], row[b]);
            }
        }
        return hash;
    }

    private static int countPairs(int rowSize) {
        return rowSize * (rowSize - 1) / 2;
    }

    private static long combine(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    private static enum CleanUp {
        NO_CLEAN_UP{

            @Override
            protected void performCleanUp(HashRowCollector collector) {
            }
        }
        ,
        SEQUENTIAL_CLEAN_UP{

            @Override
            protected void performCleanUp(HashRowCollector collector) {
                LinkedList hashes = collector.hashes;
                Iterator rowsIterator = collector.rows.iterator();
                Iterator hashIterator = collector.hashes.iterator();
                int index = 1;
                while (hashIterator.hasNext()) {
                    rowsIterator.next();
                    if (HashRowCollector.isUniqueHashPresent((long[])hashIterator.next(), hashes.subList(index, hashes.size()))) {
                        ++index;
                        continue;
                    }
                    rowsIterator.remove();
                    hashIterator.remove();
                }
            }
        }
        ,
        FULL_CLEAN_UP{

            @Override
            protected void performCleanUp(HashRowCollector collector) {
                Iterator rowsIterator = collector.rows.descendingIterator();
                Iterator hashIterator = collector.hashes.descendingIterator();
                while (hashIterator.hasNext()) {
                    rowsIterator.next();
                    if (HashRowCollector.isUniqueHashPresent((long[])hashIterator.next(), collector.hashes)) continue;
                    rowsIterator.remove();
                    hashIterator.remove();
                }
            }
        };


        protected abstract void performCleanUp(HashRowCollector var1);
    }
}

