/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.mock;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.whaka.mock.EventCollector;

public class ChainEventHandler<Event>
implements EventCollector.EventHandler<Event> {
    private final List<Predicate<? super Event>> eventFilters;
    private final List<EventCollector.EventHandler<? super Event>> eventHandlers;

    public ChainEventHandler(Collection<Predicate<? super Event>> filters) {
        filters.forEach(f -> Objects.requireNonNull(f, "Event predicate cannot be null!"));
        Preconditions.checkArgument((filters.size() > 1 ? 1 : 0) != 0, (Object)"Cannot chain less than 2 filters!");
        this.eventFilters = ImmutableList.copyOf(filters);
        this.eventHandlers = filters.stream().filter(EventCollector.EventHandler.class::isInstance).map(p -> (EventCollector.EventHandler)p).collect(Collectors.toList());
    }

    @Override
    public boolean test(Event t) {
        return this.eventFilters.stream().allMatch(p -> p.test(t));
    }

    @Override
    public void eventCollected(Event event) {
        this.eventHandlers.forEach(h -> h.eventCollected(event));
    }
}

