/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.mock;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.listeners.InvocationListener;
import org.whaka.mock.EventCombiner;
import org.whaka.util.UberStreams;
import org.whaka.util.function.UberStream;

public class EventCollector<Target, Event> {
    private final Target target;
    private final DescribedInvocation invocation;
    private final EventCombiner<Target, Event> combiner;
    private final List<Predicate<? super Event>> eventFilters;
    private final List<EventHandler<? super Event>> eventHandlers;
    private final List<Event> events = new ArrayList<Event>();

    private EventCollector(Class<Target> targetClass, EventCombiner<Target, Event> combiner, Collection<Predicate<? super Event>> filters) {
        this.combiner = Objects.requireNonNull(combiner, "Event combiner cannot be null!");
        this.eventFilters = ImmutableList.copyOf(filters);
        this.eventHandlers = EventCollector.selectEventHandlers(filters);
        ArrayList invocations = new ArrayList();
        MockSettings settings = Mockito.withSettings().invocationListeners(new InvocationListener[]{report -> invocations.add(report.getInvocation())});
        this.target = Mockito.mock(targetClass, (MockSettings)settings);
        combiner.accept(Mockito.doAnswer(this::answer).when(this.target));
        if (invocations.size() != 1) {
            throw new IllegalStateException("Single listener interaction was expected! But actual: " + invocations);
        }
        this.invocation = (DescribedInvocation)invocations.get(0);
    }

    private static <E> List<EventHandler<? super E>> selectEventHandlers(Collection<Predicate<? super E>> filters) {
        return filters.stream().filter(EventHandler.class::isInstance).map(p -> (EventHandler)p).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T, E> EventCollector<T, E> create(Class<T> targetClass, BiConsumer<T, E> method, Predicate<? super E> ... filters) {
        return EventCollector.create(targetClass, method, Arrays.asList(filters));
    }

    public static <T, E> EventCollector<T, E> create(Class<T> targetClass, BiConsumer<T, E> method, Collection<Predicate<? super E>> filters) {
        return EventCollector.create(targetClass, EventCombiner.create(method), filters);
    }

    @SafeVarargs
    public static <T, E> EventCollector<T, E> create(Class<T> targetClass, EventCombiner<T, E> captor, Predicate<? super E> ... filters) {
        return EventCollector.create(targetClass, captor, Arrays.asList(filters));
    }

    public static <T, E> EventCollector<T, E> create(Class<T> targetClass, EventCombiner<T, E> captor, Collection<Predicate<? super E>> filters) {
        return new EventCollector(targetClass, captor, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object answer(InvocationOnMock invoke) {
        Object event = this.combiner.getValue();
        List<Event> list = this.events;
        synchronized (list) {
            if (this.testEvent(event)) {
                this.events.add(event);
                this.eventHandlers.forEach(c -> c.eventCollected(event));
            }
        }
        return null;
    }

    private boolean testEvent(Event e) {
        return !((UberStream)UberStreams.stream(this.eventFilters).map(p -> p.test(e))).toSet().contains(false);
    }

    public Target getTarget() {
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<Event> list = this.events;
        synchronized (list) {
            return this.events.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getEvents() {
        List<Event> list = this.events;
        synchronized (list) {
            return ImmutableList.copyOf(this.events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event getLastEvent() {
        List<Event> list = this.events;
        synchronized (list) {
            Preconditions.checkState((!this.events.isEmpty() ? 1 : 0) != 0, (Object)"No events were captured!");
            return this.events.get(this.events.size() - 1);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", this.getTarget()).add("stub", (Object)this.invocation).add("combiner", this.combiner).add("filters", this.eventFilters.size()).add("handlers", this.eventHandlers.size()).toString();
    }

    public static interface EventHandler<Event>
    extends Predicate<Event> {
        public void eventCollected(Event var1);
    }
}

