/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.mock;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.mockito.ArgumentCaptor;
import org.whaka.util.UberStreams;
import org.whaka.util.function.Consumer3;
import org.whaka.util.function.Consumer4;
import org.whaka.util.function.Consumer5;
import org.whaka.util.function.Tuple2;
import org.whaka.util.function.Tuple3;
import org.whaka.util.function.Tuple4;
import org.whaka.util.function.UberStream;

public class EventCombiner<Target, Event>
implements Consumer<Target> {
    private final ArgumentCaptor<?>[] captors;
    private final BiConsumer<Target, ArgumentCaptor<?>[]> methodCall;
    private final Function<Object[], Event> combiner;

    private EventCombiner(int numberOfEvents, BiConsumer<Target, ArgumentCaptor<?>[]> methodCall, Function<Object[], Event> combiner) {
        Preconditions.checkArgument((numberOfEvents > 0 ? 1 : 0) != 0, (Object)"Expected positive number of events!");
        this.methodCall = Objects.requireNonNull(methodCall, "Method call cannot be null!");
        this.combiner = Objects.requireNonNull(combiner, "Arguments combiner cannot be null!");
        this.captors = (ArgumentCaptor[])IntStream.range(0, numberOfEvents).mapToObj(i -> ArgumentCaptor.forClass(Object.class)).toArray(ArgumentCaptor[]::new);
    }

    public static <T, E> EventCombiner<T, E> forCaptors(int numberOfEvents, BiConsumer<T, ArgumentCaptor<?>[]> methodCall, Function<Object[], E> combiner) {
        return new EventCombiner<T, E>(numberOfEvents, methodCall, combiner);
    }

    public static <T, E> EventCombiner<T, E> forCaptor(BiConsumer<T, ArgumentCaptor<E>> methodCall) {
        return EventCombiner.forCaptors(1, (t, captors) -> methodCall.accept(t, captors[0]), arr -> arr[0]);
    }

    public static <T, E> EventCombiner<T, E> forValues(int numberOfEvents, BiConsumer<T, Object[]> methodCall, Function<Object[], E> combiner) {
        Objects.requireNonNull(methodCall, "Method call cannot be null!");
        return EventCombiner.forCaptors(numberOfEvents, (t, captors) -> methodCall.accept(t, ((UberStream)UberStreams.stream(captors).map(c -> c.capture())).toArray()), combiner);
    }

    public static <T, E> EventCombiner<T, E> create(BiConsumer<T, E> methodCall) {
        Objects.requireNonNull(methodCall, "Method call cannot be null!");
        return EventCombiner.forValues(1, (t, arr) -> methodCall.accept(t, arr[0]), arr -> arr[0]);
    }

    public static <T, A, B> EventCombiner<T, Tuple2<A, B>> create(Consumer3<T, A, B> methodCall) {
        Objects.requireNonNull(methodCall, "Method call cannot be null!");
        return EventCombiner.forValues(2, (t, arr) -> methodCall.accept(t, arr[0], arr[1]), arr -> Tuple2.tuple2(arr[0], arr[1]));
    }

    public static <T, A, B, C> EventCombiner<T, Tuple3<A, B, C>> create(Consumer4<T, A, B, C> methodCall) {
        Objects.requireNonNull(methodCall, "Method call cannot be null!");
        return EventCombiner.forValues(3, (t, arr) -> methodCall.accept(t, arr[0], arr[1], arr[2]), arr -> Tuple3.tuple3(arr[0], arr[1], arr[2]));
    }

    public static <T, A, B, C, D> EventCombiner<T, Tuple4<A, B, C, D>> create(Consumer5<T, A, B, C, D> methodCall) {
        Objects.requireNonNull(methodCall, "Method call cannot be null!");
        return EventCombiner.forValues(4, (t, arr) -> methodCall.accept(t, arr[0], arr[1], arr[2], arr[3]), arr -> Tuple4.tuple4(arr[0], arr[1], arr[2], arr[3]));
    }

    public ArgumentCaptor<?>[] getCaptors() {
        return (ArgumentCaptor[])this.captors.clone();
    }

    public BiConsumer<Target, ArgumentCaptor<?>[]> getMethodCall() {
        return this.methodCall;
    }

    public Function<Object[], Event> getCombiner() {
        return this.combiner;
    }

    @Override
    public void accept(Target t) {
        this.getMethodCall().accept(t, this.getCaptors());
    }

    public Event getValue() {
        Object[] values = ((UberStream)UberStreams.stream(this.getCaptors()).map(c -> c.getValue())).toArray();
        return this.getCombiner().apply(values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("captors", this.getCaptors().length).addValue(System.identityHashCode(this)).toString();
    }
}

