/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.mock;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.whaka.mock.ChainEventHandler;
import org.whaka.mock.EventCollector;
import org.whaka.mock.LatchEventHandler;
import org.whaka.util.UberPredicates;

public final class EventHandlers {
    private EventHandlers() {
    }

    public static LatchEventHandler latch(int count) {
        return new LatchEventHandler(new CountDownLatch(count));
    }

    public static <E> Predicate<E> skip(long n) {
        return UberPredicates.counter(n, false);
    }

    public static <E> Predicate<E> manual(AtomicBoolean flag) {
        return UberPredicates.fromSupplier(flag::get);
    }

    @SafeVarargs
    public static <E> EventCollector.EventHandler<E> chain(Predicate<? super E> ... filters) {
        return EventHandlers.chain(Arrays.asList(filters));
    }

    public static <E> EventCollector.EventHandler<E> chain(Collection<Predicate<? super E>> filters) {
        return new ChainEventHandler(filters);
    }

    public static <E> EventCollector.EventHandler<E> collectCallback(Consumer<E> consumer) {
        return EventHandlers.functional(p -> true, consumer);
    }

    public static <E> EventCollector.EventHandler<E> functional(final Predicate<? super E> predicate, final Consumer<? super E> consumer) {
        return new EventCollector.EventHandler<E>(){

            @Override
            public boolean test(E t) {
                return predicate.test(t);
            }

            @Override
            public void eventCollected(E event) {
                consumer.accept(event);
            }
        };
    }
}

