/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.mock;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.whaka.mock.EventCollector;

public class LatchEventHandler
implements EventCollector.EventHandler<Object> {
    private final Object lock = new Object();
    private final CountDownLatch latch;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public LatchEventHandler(CountDownLatch latch) {
        this.latch = latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.open.get() && this.getLatch().getCount() > 0L;
        }
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.open.set(false);
        }
    }

    public boolean awaitSeconds(int second) {
        return this.await(second, TimeUnit.SECONDS);
    }

    public boolean awaitMillis(long millis) {
        return this.await(millis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (!this.open.get()) {
                    return false;
                }
            }
            return this.getLatch().await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean awaitSecondsAndClose(int seconds) {
        return this.awaitAndClose(seconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitAndClose(long timeout, TimeUnit unit) {
        try {
            boolean bl = this.await(timeout, unit);
            return bl;
        }
        finally {
            this.close();
        }
    }

    @Override
    public boolean test(Object t) {
        return this.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventCollected(Object event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.open.get()) {
                this.latch.countDown();
            }
        }
    }
}

