/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.whaka.util.Destroyable;

public abstract class AbstractDestroyable
implements Destroyable {
    private final AtomicBoolean destroyed = new AtomicBoolean();

    @Override
    public final synchronized void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.doDestroy();
        }
    }

    protected void doDestroy() {
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected final void assertNotDestroyed() throws IllegalStateException {
        Preconditions.checkState((!this.isDestroyed() ? 1 : 0) != 0, (Object)"Instance cannot be used after 'destroy()' method is called!");
    }
}

