/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.whaka.util.AbstractDestroyable;
import org.whaka.util.Initializable;

public abstract class AbstractInitializableAndDestroyable
extends AbstractDestroyable
implements Initializable {
    private final AtomicBoolean initialized = new AtomicBoolean();

    @Override
    public final void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            this.doInitialize();
        }
    }

    protected void doInitialize() {
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized.get();
    }

    protected final void assertInitialized() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isInitialized(), (Object)"Instance cannot be used before 'initialize()' method is called!");
    }
}

