/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;

public final class DoubleMath {
    public static final int MAXIMUM_DEFAULT_DECIMALS = 14;
    public static final int MAXIMUM_POSSIBLE_DECIMALS = 42;

    private DoubleMath() {
    }

    public static Double asDouble(Number x) {
        return x == null ? null : (x instanceof Double ? (Double)x : Double.valueOf(x.doubleValue()));
    }

    public static boolean isZero(Double d) {
        return DoubleMath.equals(d, 0.0);
    }

    public static boolean isPositive(Double d) {
        return DoubleMath.isNumber(d) && DoubleMath.compare(d, 0.0) > 0;
    }

    public static boolean isNegative(Double d) {
        return DoubleMath.isNumber(d) && DoubleMath.compare(d, 0.0) < 0;
    }

    public static boolean isFinite(Double d) {
        return d != null && Double.isFinite(d);
    }

    public static boolean isNumber(Double d) {
        return d != null && !Double.isNaN(d);
    }

    public static boolean equals(Double a, Double b) {
        if (a == null || b == null) {
            return a == b;
        }
        return DoubleMath.compare(a, b) == 0;
    }

    public static boolean equals(Double a, Double b, double accuracy) {
        if (a == null || b == null) {
            return a == b;
        }
        return DoubleMath.compare(a, b, accuracy) == 0;
    }

    public static int compare(double a, double b) {
        return DoubleMath.performCompareWithOptionalAccuracy(a, b, null);
    }

    public static int compare(double a, double b, double accuracy) {
        Preconditions.checkArgument((Double.isFinite(accuracy) && accuracy >= 0.0 ? 1 : 0) != 0, (Object)"Accuracy should be a finite positive number!");
        return DoubleMath.performCompareWithOptionalAccuracy(a, b, accuracy);
    }

    private static int performCompareWithOptionalAccuracy(double a, double b, Double accuracy) {
        double delta;
        if (!Double.isFinite(a) || !Double.isFinite(b)) {
            return Double.compare(a, b);
        }
        int lastDecimal = DoubleMath.getLastAffectedDecimal(a);
        if (lastDecimal != DoubleMath.getLastAffectedDecimal(b)) {
            return Double.compare(a, b);
        }
        if (accuracy == null) {
            accuracy = Math.pow(10.0, -lastDecimal);
        }
        if (Math.abs(delta = DoubleMath.roundTo(a - b, lastDecimal + 1)) >= accuracy) {
            return (int)Math.signum(delta);
        }
        return 0;
    }

    public static double round(double a) {
        return DoubleMath.roundTo(a, DoubleMath.getLastAffectedDecimal(a));
    }

    public static int getLastAffectedDecimal(double d) {
        if (!Double.isFinite(d)) {
            return 0;
        }
        int decimalPosition = (int)Math.log10(Math.abs(d));
        if (decimalPosition < 0) {
            return 14;
        }
        if (decimalPosition > 14) {
            return 0;
        }
        return 14 - decimalPosition;
    }

    public static double roundTo(double a, int decimals) {
        Preconditions.checkArgument((Math.abs(decimals) <= 42 ? 1 : 0) != 0, (Object)"Illegal decimals! Max possible value: 42");
        if (!Double.isFinite(a)) {
            return a;
        }
        if (decimals == 0) {
            return Math.round(a);
        }
        double pow = Math.pow(10.0, decimals);
        return (double)Math.round(a * pow) / pow;
    }
}

