/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessageBuilder {
    private final Map<String, Object> parameters = new LinkedHashMap<String, Object>();

    public MessageBuilder putParameter(String key, Object parameter) {
        this.getParameters().put(key, parameter);
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String build(String message) {
        return this.build(message, new Object[0]);
    }

    public String build(String message, Object ... args) {
        message = String.format(Strings.nullToEmpty((String)message), args);
        return MessageBuilder.build(message, this.getParameters());
    }

    public static String build(String message, Map<String, Object> messageParameters) {
        message = Strings.nullToEmpty((String)message);
        if (messageParameters == null || messageParameters.isEmpty()) {
            return message;
        }
        return message + messageParameters.entrySet().toString();
    }
}

