/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import java.util.Objects;
import org.whaka.util.function.DangerousConsumer;

public class Resource<T, E extends Exception>
implements AutoCloseable {
    private final T value;
    private final DangerousConsumer<T, E> close;

    private Resource(T value, DangerousConsumer<T, E> close) {
        this.value = Objects.requireNonNull(value, "Resource cannot be null!");
        this.close = Objects.requireNonNull(close, "Close operation cannot be null!");
    }

    public static <T, E extends Exception> Resource<T, E> create(T value, DangerousConsumer<T, E> close) {
        return new Resource<T, E>(value, close);
    }

    public T getValue() {
        return this.value;
    }

    public DangerousConsumer<T, E> getClose() {
        return this.close;
    }

    @Override
    public void close() throws E {
        this.getClose().accept(this.getValue());
    }
}

