/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import org.whaka.util.Try;
import org.whaka.util.function.DangerousBiConsumer;
import org.whaka.util.function.DangerousBiFunction;
import org.whaka.util.function.DangerousConsumer;
import org.whaka.util.function.DangerousFunction;

@FunctionalInterface
public interface Timeout {
    public static Timeout create(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"Milliseconds cannot be negative!");
        return () -> millis;
    }

    public long getMillis();

    default public boolean sleep() {
        return Try.run(() -> Thread.sleep(this.getMillis())).isSuccess();
    }

    default public void await(LongConsumer operation) {
        operation.accept(this.getMillis());
    }

    default public void awaitDangerous(DangerousConsumer<Long, ?> operation, String name) {
        try {
            operation.accept(this.getMillis());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to await '%s'!", name), e);
        }
    }

    default public void await(BiConsumer<Long, TimeUnit> operation) {
        operation.accept(this.getMillis(), TimeUnit.MILLISECONDS);
    }

    default public void awaitDangerous(DangerousBiConsumer<Long, TimeUnit, ?> operation, String name) {
        try {
            operation.accept(this.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to await '%s'!", name), e);
        }
    }

    default public <T> T awaitAndGet(LongFunction<T> operation) {
        return operation.apply(this.getMillis());
    }

    default public <T> T awaitAndGetDangerous(DangerousFunction<Long, T, ?> operation, String name) {
        try {
            return operation.apply(this.getMillis());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to await '%s'!", name), e);
        }
    }

    default public <T> T awaitAndGet(BiFunction<Long, TimeUnit, T> operation) {
        return operation.apply(this.getMillis(), TimeUnit.MILLISECONDS);
    }

    default public <T> T awaitAndGetDangerous(DangerousBiFunction<Long, TimeUnit, T, ?> operation, String name) {
        try {
            return operation.apply(this.getMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to await '%s'!", name), e);
        }
    }
}

