/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.whaka.asserts.Assert;
import org.whaka.asserts.UberMatchers;
import org.whaka.util.function.DangerousBiFunction;
import org.whaka.util.function.DangerousConsumer;
import org.whaka.util.function.DangerousFunction;
import org.whaka.util.function.DangerousRunnable;
import org.whaka.util.function.DangerousSupplier;

public class Try<R> {
    private final R result;
    private final Exception cause;
    private final AtomicBoolean caught;
    private final Throwable suppressed;

    private Try(R result, Exception cause) {
        this(result, cause, null);
    }

    private Try(R result, Exception cause, Throwable suppressed) {
        this(result, cause, suppressed, false);
    }

    private Try(R result, Exception cause, Throwable suppressed, boolean caught) {
        this.result = result;
        this.cause = cause;
        this.suppressed = suppressed;
        this.caught = new AtomicBoolean(caught);
    }

    public static Try<Void> run(DangerousRunnable<Exception> code) {
        try {
            code.run();
            return new Try<Object>(null, null);
        }
        catch (Exception e) {
            return new Try<Object>(null, e);
        }
    }

    public static <R> Try<R> perform(DangerousSupplier<R, Exception> code) {
        try {
            return new Try<R>(code.get(), null);
        }
        catch (Exception e) {
            return new Try<Object>(null, e);
        }
    }

    public static <Res extends AutoCloseable, R> Try<R> withResource(DangerousSupplier<Res, Exception> resourceSupplier, DangerousFunction<Res, R, Exception> code) {
        Throwable suppressed;
        Exception cause;
        R result;
        block15: {
            result = null;
            cause = null;
            suppressed = null;
            boolean success = false;
            try (AutoCloseable resource = (AutoCloseable)resourceSupplier.get();){
                result = code.apply(resource);
                success = true;
            }
            catch (Exception e) {
                if (success) {
                    suppressed = e;
                }
                cause = e;
                if (e.getSuppressed().length <= 0) break block15;
                suppressed = e.getSuppressed()[0];
            }
        }
        return new Try<Object>(result, cause, suppressed);
    }

    public R getResult() {
        return this.result;
    }

    public Optional<R> getOptionalResult() {
        return Optional.ofNullable(this.getResult());
    }

    public R getOrElse(R inCaseOfFail) {
        return this.isSuccess() ? this.getResult() : inCaseOfFail;
    }

    public Exception getCause() {
        return this.cause;
    }

    public Throwable getSuppressed() {
        return this.suppressed;
    }

    public boolean isSuccess() {
        return this.getCause() == null;
    }

    public boolean isCaught() {
        return this.caught.get();
    }

    public Try<R> onAnyResult(BiConsumer<R, Exception> consumer) {
        consumer.accept(this.getResult(), this.getCause());
        return this;
    }

    public Try<R> onPerformSuccess(Consumer<R> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.getResult());
        }
        return this;
    }

    public <V> Try<V> onPerformSuccessTry(DangerousFunction<R, V, Exception> mapper) {
        if (this.isSuccess()) {
            return Try.perform(() -> mapper.apply(this.getResult()));
        }
        return new Try<Object>(null, this.getCause(), this.getSuppressed(), this.isCaught());
    }

    public <Res extends AutoCloseable, V> Try<V> onPerformSuccessTryWithResource(DangerousSupplier<Res, Exception> resourceSupplier, DangerousBiFunction<Res, R, V, Exception> mapper) {
        if (this.isSuccess()) {
            return Try.withResource(resourceSupplier, resource -> mapper.apply(resource, this.getResult()));
        }
        return new Try<Object>(null, this.getCause(), this.getSuppressed(), this.isCaught());
    }

    public Try<R> onPerformFail(Consumer<Exception> consumer) {
        if (!this.isSuccess()) {
            consumer.accept(this.getCause());
        }
        return this;
    }

    public <E extends Exception> Try<R> onPerformFailDangerous(DangerousConsumer<Exception, E> consumer) throws E {
        if (!this.isSuccess()) {
            consumer.accept(this.getCause());
        }
        return this;
    }

    public <T extends Throwable> Try<R> onPerformFailThrow(Function<Exception, T> function) throws T {
        if (!this.isSuccess()) {
            throw (Throwable)function.apply(this.getCause());
        }
        return this;
    }

    public Try<R> onPerformFailRethrow() throws Exception {
        if (!this.isSuccess()) {
            throw this.getCause();
        }
        return this;
    }

    public <T extends Exception, E extends Exception> Try<R> onPerformFailCatch(Class<T> type, DangerousConsumer<T, E> consumer) throws E {
        if (type.isInstance(this.getCause()) && this.caught.compareAndSet(false, true)) {
            consumer.accept(this.getCause());
        }
        return this;
    }

    public Try<R> assertFail(Matcher<? super Exception> matcher) {
        return this.assertFail(matcher, null);
    }

    public Try<R> assertFail(Matcher<? super Exception> matcher, String message) {
        if (!this.isSuccess()) {
            Assert.assertThat(this.getCause(), matcher, message);
        }
        return this;
    }

    public Try<R> assertFailNotExpected() {
        return this.assertFailNotExpected(null);
    }

    public Try<R> assertFailNotExpected(String message) {
        return this.assertFail(UberMatchers.notExpected(), message);
    }

    public Try<R> assertFailIsInstanceOf(Class<? extends Exception> type) {
        return this.assertFailIsInstanceOf(type, null);
    }

    public Try<R> assertFailIsInstanceOf(Class<? extends Exception> type, String message) {
        return this.assertFail(UberMatchers.throwableOfType(type), message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.isSuccess() ? this.getResult() : this.getCause()).toString();
    }
}

