/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public class UberArrays {
    private UberArrays() {
    }

    public static Object[] eliminateCollections(Object[] array) {
        Object[] result = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = UberArrays.eliminateCollections(array[i]);
        }
        return result;
    }

    private static Object eliminateCollections(Object o) {
        if (o instanceof Collection) {
            return UberArrays.eliminateCollections(((Collection)o).toArray());
        }
        if (o instanceof Object[]) {
            return UberArrays.eliminateCollections((Object[])((Object[])o).clone());
        }
        return o;
    }

    public static int getArrayDepth(Class<?> arrayClass) {
        int depth = 0;
        while (arrayClass.isArray()) {
            ++depth;
            arrayClass = arrayClass.getComponentType();
        }
        return depth;
    }

    public static Class<?> createArrayClass(Class<?> componentType, int depth) {
        Preconditions.checkArgument((depth < 256 ? 1 : 0) != 0, (Object)"Array depth cannot be greater than 255!");
        if (depth > 0) {
            for (int i = 0; i < depth; ++i) {
                componentType = Array.newInstance(componentType, 0).getClass();
            }
        } else {
            for (int i = depth; i < 0 && componentType.isArray(); ++i) {
                componentType = componentType.getComponentType();
            }
        }
        return componentType;
    }

    public static String toString(Object o) {
        if (o != null && o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return Arrays.toString((boolean[])o);
            }
            if (o instanceof byte[]) {
                return Arrays.toString((byte[])o);
            }
            if (o instanceof short[]) {
                return Arrays.toString((short[])o);
            }
            if (o instanceof char[]) {
                return Arrays.toString((char[])o);
            }
            if (o instanceof int[]) {
                return Arrays.toString((int[])o);
            }
            if (o instanceof long[]) {
                return Arrays.toString((long[])o);
            }
            if (o instanceof float[]) {
                return Arrays.toString((float[])o);
            }
            if (o instanceof double[]) {
                return Arrays.toString((double[])o);
            }
            if (o instanceof Object[]) {
                return Arrays.deepToString(UberArrays.eliminateCollections((Object[])o));
            }
        }
        return String.valueOf(o);
    }
}

