/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whaka.util.Destroyable;
import org.whaka.util.function.DangerousConsumer;

public final class UberCloser {
    private static final Logger log = LoggerFactory.getLogger(UberCloser.class);

    private UberCloser() {
    }

    public static void close(AutoCloseable closeable) {
        UberCloser.close(closeable, String.valueOf(closeable));
    }

    public static void close(AutoCloseable closeable, String name) {
        UberCloser.close(closeable, AutoCloseable::close, name);
    }

    public static void close(Destroyable destroyable) {
        UberCloser.close(destroyable, String.valueOf(destroyable));
    }

    public static void close(Destroyable destroyable, String name) {
        UberCloser.close(destroyable, Destroyable::destroy, name);
    }

    public static <T> void close(T target, DangerousConsumer<T, ?> operation) {
        UberCloser.close(target, operation, String.valueOf(target));
    }

    public static <T> void close(T target, DangerousConsumer<T, ?> operation, String name) {
        if (target == null) {
            log.trace("Target '{}' is null. Ignoring.");
            return;
        }
        try {
            log.trace("Closing '{}'");
            operation.accept(target);
        }
        catch (Exception e) {
            throw new CloseException(String.format("Failed to close '%s'!", name), e);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        UberCloser.closeQuietly(closeable, String.valueOf(closeable));
    }

    public static void closeQuietly(AutoCloseable closeable, String name) {
        UberCloser.closeQuietly(closeable, AutoCloseable::close, name);
    }

    public static void closeQuietly(Destroyable destroyable) {
        UberCloser.closeQuietly(destroyable, String.valueOf(destroyable));
    }

    public static void closeQuietly(Destroyable destroyable, String name) {
        UberCloser.closeQuietly(destroyable, Destroyable::destroy, name);
    }

    public static <T> void closeQuietly(T target, DangerousConsumer<T, ?> operation) {
        UberCloser.closeQuietly(target, operation, String.valueOf(target));
    }

    public static <T> void closeQuietly(T target, DangerousConsumer<T, ?> operation, String name) {
        if (target == null) {
            log.trace("Target '{}' is null. Ignoring.");
            return;
        }
        try {
            log.trace("Closing '{}'");
            operation.accept(target);
        }
        catch (Exception e) {
            log.warn("Failed to close '{}'!", (Object)name, (Object)e);
        }
    }

    public static class CloseException
    extends RuntimeException {
        public CloseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

