/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.whaka.util.UberArrays;
import org.whaka.util.UberLists;

public class UberCollections {
    public static final BiPredicate DEEP_EQUALS_PREDICATE = new BiPredicate(){

        public boolean test(Object a, Object b) {
            if (a instanceof Collection && b instanceof Collection) {
                return UberCollections.containsEqualElements((Collection)a, (Collection)b, this);
            }
            return Objects.deepEquals(a, b);
        }
    };

    private UberCollections() {
    }

    public static <T> boolean containsEqualElements(Collection<? extends T> col1, Collection<? extends T> col2) {
        return UberCollections.containsEqualElements(col1, col2, UberCollections.deepEqualsPredicate());
    }

    public static <T> boolean containsEqualElements(Collection<? extends T> col1, Collection<? extends T> col2, BiPredicate<T, T> predicate) {
        if ((col1 == null || col2 == null) && col1 != col2) {
            return false;
        }
        if (col1 == col2) {
            return true;
        }
        return col1.size() == col2.size() && UberCollections.containsAll(col1, col2, predicate);
    }

    public static <T> boolean contains(Collection<? extends T> col, T element, BiPredicate<T, T> predicate) {
        return UberCollections.containsAny(col, Collections.singleton(element), predicate);
    }

    public static <T> boolean containsAny(Collection<? extends T> col, Collection<? extends T> anyOf) {
        return UberCollections.containsAny(col, anyOf, UberCollections.deepEqualsPredicate());
    }

    public static <T> boolean containsAny(Collection<? extends T> col, Collection<? extends T> anyOf, BiPredicate<T, T> predicate) {
        if (anyOf.isEmpty()) {
            return true;
        }
        for (T o : anyOf) {
            for (T t : col) {
                if (!predicate.test(t, o)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsAll(Collection<? extends T> col, Collection<? extends T> allOf) {
        return UberCollections.containsAll(col, allOf, UberCollections.deepEqualsPredicate());
    }

    public static <T> boolean containsAll(Collection<? extends T> col, Collection<? extends T> allOf, BiPredicate<T, T> predicate) {
        ArrayList<T> list = new ArrayList<T>(col);
        for (T item : allOf) {
            int idx = UberLists.getIndex(list, item, predicate);
            if (idx < 0) {
                return false;
            }
            list.remove(idx);
        }
        return true;
    }

    public static String toString(Collection<?> collection) {
        return collection == null ? "null" : UberArrays.toString(collection.toArray());
    }

    public static Object[] toArrayRecursive(Collection<?> col) {
        return UberArrays.eliminateCollections(col.toArray());
    }

    public static <T> BiPredicate<T, T> deepEqualsPredicate() {
        return DEEP_EQUALS_PREDICATE;
    }
}

