/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.whaka.util.UberPredicates;

public class UberIterators {
    private UberIterators() {
    }

    public static <T> Iterable<T> iterate(T seed, Function<T, T> next, Predicate<T> validator) {
        return () -> new FunctionIterator<Object>(seed, next, validator);
    }

    public static class FunctionIterator<T>
    implements Iterator<T> {
        private final AtomicReference<T> ref;
        private final Function<T, T> next;
        private final Predicate<T> validator;

        public FunctionIterator(T seed, Function<T, T> next, Predicate<T> validator) {
            this.ref = new AtomicReference<T>(seed);
            this.next = next;
            this.validator = UberPredicates.distinct(validator);
        }

        @Override
        public boolean hasNext() {
            return this.validator.test(this.ref.get());
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.ref.getAndUpdate(this.next::apply);
        }
    }
}

