/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class UberMaps {
    private UberMaps() {
    }

    public static <K, V> Entry<K, V> entry(Map.Entry<K, V> e) {
        return e instanceof Entry ? (Entry<K, V>)e : UberMaps.entry(e.getKey(), e.getValue());
    }

    public static <K, V> Entry<K, V> entry(K key, V val) {
        return new Entry<K, V>(key, val);
    }

    public static final class Entry<K, V>
    implements Map.Entry<K, V>,
    Predicate<Map<K, V>>,
    Cloneable {
        public final K key;
        public final V val;

        public Entry(K key, V val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public K key() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        public V val() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean test(Map<K, V> t) {
            return t.containsKey(this.key) && Objects.equals(this.val, t.get(this.key));
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey(), this.getValue());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == this.getClass()) {
                Entry that = (Entry)obj;
                return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).addValue((Object)(this.getKey() + "=" + this.getValue())).toString();
        }

        public Map.Entry<K, V> clone() {
            return new Entry<K, V>(this.key, this.val);
        }

        public static <K, V> Function<Entry<K, V>, Entry<V, K>> swap() {
            return e -> UberMaps.entry(e.val, e.key);
        }
    }
}

