/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class UberPredicates {
    private UberPredicates() {
    }

    public static <T> Predicate<T> counter(long n, boolean value) {
        Preconditions.checkArgument((n > 0L ? 1 : 0) != 0, (Object)"Positive number is expected!");
        AtomicLong counter = new AtomicLong(n);
        return p -> counter.getAndUpdate(l -> l > 0L ? l - 1L : 0L) > 0L ? value : !value;
    }

    public static <T> Predicate<T> peek(Consumer<? super T> consumer, boolean result) {
        return t -> {
            consumer.accept(t);
            return result;
        };
    }

    public static <T> Predicate<T> peekTrue(Consumer<? super T> consumer) {
        return UberPredicates.peek(consumer, true);
    }

    public static <T> Predicate<T> peekFalse(Consumer<? super T> consumer) {
        return UberPredicates.peek(consumer, false);
    }

    public static <T> Predicate<T> fromSupplier(BooleanSupplier sup) {
        return t -> sup.getAsBoolean();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<T> ... predicates) {
        return UberPredicates.anyOf(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> anyOf(Collection<Predicate<T>> predicates) {
        ArrayList copy = new ArrayList(predicates);
        return t -> copy.stream().anyMatch(p -> p.test(t));
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<T> ... predicates) {
        return UberPredicates.allOf(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> allOf(Collection<Predicate<T>> predicates) {
        ArrayList copy = new ArrayList(predicates);
        return t -> copy.stream().allMatch(p -> p.test(t));
    }

    @SafeVarargs
    public static <T> Predicate<T> noneOf(Predicate<T> ... predicates) {
        return UberPredicates.noneOf(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> noneOf(Collection<Predicate<T>> predicates) {
        return UberPredicates.not(UberPredicates.anyOf(predicates));
    }

    public static <T> Predicate<T> distinct(Predicate<T> delegate) {
        return new DistinctPredicateProxy<T>(delegate);
    }

    public static class DistinctPredicateProxy<T>
    implements Predicate<T> {
        private final AtomicBoolean everCalled = new AtomicBoolean();
        private final BiPredicate<T, T> distinctionPredicate;
        private final Predicate<T> delegate;
        private T prevArgument;
        private boolean lastResult;

        public DistinctPredicateProxy(Predicate<T> delegate) {
            this(delegate, (a, b) -> a != b);
        }

        public DistinctPredicateProxy(Predicate<T> delegate, BiPredicate<T, T> distinctionPredicate) {
            this.distinctionPredicate = distinctionPredicate;
            this.delegate = delegate;
        }

        @Override
        public boolean test(T t) {
            if (!this.everCalled.getAndSet(true) || this.distinctionPredicate.test(this.prevArgument, t)) {
                this.prevArgument = t;
                this.lastResult = this.delegate.test(t);
            }
            return this.lastResult;
        }
    }
}

