/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.whaka.util.function.Tuple2;
import org.whaka.util.function.Tuple3;

@FunctionalInterface
public interface Consumer3<A, B, C> {
    public void accept(A var1, B var2, C var3);

    public static <A, B, C> Consumer<Tuple3<A, B, C>> toConsumer(Consumer3<A, B, C> delegate) {
        return e -> delegate.accept(e._1, e._2, e._3);
    }

    public static <A, B, C> BiConsumer<A, Tuple2<B, C>> toBiConsumer(Consumer3<A, B, C> delegate) {
        return (a, e) -> delegate.accept(a, e._1, e._2);
    }

    default public Consumer3<A, B, C> andThen(Consumer3<? super A, ? super B, ? super C> after) {
        Objects.requireNonNull(after, "Chained consumer cannot be null!");
        return (a, b, c) -> {
            this.accept(a, b, c);
            after.accept(a, b, c);
        };
    }
}

