/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MapCollectors {
    private MapCollectors() {
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap() {
        return MapCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> toMap(Supplier<M> mapSupplier) {
        return MapCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mapSupplier);
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return MapCollectors.toMap(keyMapper, valueMapper, MapCollectors.replacingMerger());
    }

    public static <T, K, V> Collector<T, ?, Map<K, V>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction) {
        return MapCollectors.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, Supplier<M> mapSupplier) {
        return MapCollectors.toMap(keyMapper, valueMapper, MapCollectors.replacingMerger(), mapSupplier);
    }

    public static <T, K, V, M extends Map<K, V>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, BinaryOperator<V> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> MapCollectors.createMapInserter(map, mergeFunction).accept(keyMapper.apply(element), valueMapper.apply(element));
        return Collector.of(mapSupplier, accumulator, MapCollectors.mapMerger(mergeFunction), new Collector.Characteristics[0]);
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                Object key = e.getKey();
                Object val = e.getValue();
                if (m1.containsKey(key)) {
                    val = mergeFunction.apply(m1.get(key), val);
                }
                m1.put(key, val);
            }
            return m1;
        };
    }

    private static <K, V> BiConsumer<K, V> createMapInserter(Map<K, V> map, BinaryOperator<V> mergeFunction) {
        return (key, val) -> {
            if (map.containsKey(key)) {
                val = mergeFunction.apply(map.get(key), val);
            }
            map.put(key, val);
        };
    }

    public static <V> BinaryOperator<V> replacingMerger() {
        return (a, b) -> b;
    }
}

