/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.whaka.util.UberMaps;
import org.whaka.util.UberPredicates;
import org.whaka.util.function.MapCollectors;
import org.whaka.util.function.UberStream;

public class MapStream<K, V>
implements Stream<UberMaps.Entry<K, V>> {
    private final Stream<UberMaps.Entry<K, V>> actual;

    public MapStream(Map<K, V> map) {
        this(map.entrySet().stream());
    }

    public MapStream(Stream<? extends Map.Entry<K, V>> actual) {
        this.actual = actual.map(UberMaps::entry);
    }

    private Stream<UberMaps.Entry<K, V>> getActual() {
        return this.actual;
    }

    @Override
    public Iterator<UberMaps.Entry<K, V>> iterator() {
        return this.getActual().iterator();
    }

    @Override
    public Spliterator<UberMaps.Entry<K, V>> spliterator() {
        return this.getActual().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.getActual().isParallel();
    }

    @Override
    public MapStream<K, V> sequential() {
        return new MapStream<K, V>((Stream)this.getActual().sequential());
    }

    @Override
    public MapStream<K, V> parallel() {
        return new MapStream<K, V>((Stream)this.getActual().parallel());
    }

    @Override
    public MapStream<K, V> unordered() {
        return new MapStream<K, V>((Stream)this.getActual().unordered());
    }

    @Override
    public MapStream<K, V> onClose(Runnable closeHandler) {
        return new MapStream<K, V>((Stream)this.getActual().onClose(closeHandler));
    }

    @Override
    public void close() {
        this.getActual().close();
    }

    public MapStream<K, V> filter(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return new MapStream<K, V>(this.getActual().filter(predicate));
    }

    public MapStream<K, V> filter(BiPredicate<K, V> predicate) {
        return this.filter((T e) -> predicate.test(e.key, e.val));
    }

    public MapStream<K, V> filterKey(Predicate<? super K> keyPredicate) {
        return this.filter((T e) -> keyPredicate.test((Object)e.key));
    }

    public MapStream<K, V> filterValue(Predicate<? super V> valPredicate) {
        return this.filter((T e) -> valPredicate.test((Object)e.val));
    }

    public <R extends K> MapStream<R, V> filterKeyByClass(Class<R> filteredKeyClass) {
        return this.filterKey(MapStream.createIsNullOrInstancePredicate(filteredKeyClass)).mapKey(filteredKeyClass::cast);
    }

    public <R extends V> MapStream<K, R> filterValueByClass(Class<R> filteredValueClass) {
        return this.filterValue(MapStream.createIsNullOrInstancePredicate(filteredValueClass)).mapValue(filteredValueClass::cast);
    }

    private static <T> Predicate<T> createIsNullOrInstancePredicate(Class<?> predicatedClass) {
        Predicate[] predicateArray = new Predicate[2];
        predicateArray[0] = Objects::isNull;
        predicateArray[1] = predicatedClass::isInstance;
        return UberPredicates.anyOf(predicateArray);
    }

    public MapStream<K, V> drop(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return this.filter((Predicate)UberPredicates.not(predicate));
    }

    public MapStream<K, V> drop(BiPredicate<K, V> predicate) {
        return this.drop((? super UberMaps.Entry<K, V> e) -> predicate.test(e.key, e.val));
    }

    public MapStream<K, V> dropKey(Predicate<? super K> keyPredicate) {
        return this.filterKey(UberPredicates.not(keyPredicate));
    }

    public MapStream<K, V> dropValue(Predicate<? super V> valPredicate) {
        return this.filterValue(UberPredicates.not(valPredicate));
    }

    @Override
    public <R> UberStream<R> map(Function<? super UberMaps.Entry<K, V>, ? extends R> mapper) {
        return new UberStream<R>(this.getActual().map(mapper));
    }

    public <K2, V2> MapStream<K2, V2> mapEntry(Function<? super UberMaps.Entry<K, V>, ? extends Map.Entry<K2, V2>> mapper) {
        return new MapStream<K, V>(this.getActual().map(mapper));
    }

    public <K2, V2> MapStream<K2, V2> mapEntry(BiFunction<K, V, ? extends Map.Entry<K2, V2>> mapper) {
        return this.mapEntry((? super UberMaps.Entry<K, V> e) -> (Map.Entry)mapper.apply(e.key, e.val));
    }

    public <K2, V2> MapStream<K2, V2> mapEntry(Function<? super K, ? extends K2> keyMapper, Function<? super V, ? extends V2> valMapper) {
        return this.mapEntry((K k, V v) -> UberMaps.entry(keyMapper.apply((Object)k), valMapper.apply((Object)v)));
    }

    public <K2> MapStream<K2, V> mapKey(Function<? super K, ? extends K2> keyMapper) {
        return this.mapEntry(keyMapper, Function.identity());
    }

    public <V2> MapStream<K, V2> mapValue(Function<? super V, ? extends V2> valMapper) {
        return this.mapEntry(Function.identity(), valMapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super UberMaps.Entry<K, V>> mapper) {
        return this.getActual().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super UberMaps.Entry<K, V>> mapper) {
        return this.getActual().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super UberMaps.Entry<K, V>> mapper) {
        return this.getActual().mapToDouble(mapper);
    }

    @Override
    public <R> UberStream<R> flatMap(Function<? super UberMaps.Entry<K, V>, ? extends Stream<? extends R>> mapper) {
        return new UberStream(this.getActual().flatMap(mapper));
    }

    public <K2, V2> MapStream<K2, V2> flatMapEntry(Function<? super UberMaps.Entry<K, V>, ? extends Map<K2, V2>> mapper) {
        return new MapStream<K, V>(this.getActual().flatMap((? super T e) -> ((Map)mapper.apply((Object)e)).entrySet().stream()));
    }

    public <K2> MapStream<K2, V> flatMapKey(Function<? super K, ? extends Collection<? extends K2>> mapper) {
        return this.flatMapEntry(e -> new MapStream(((Collection)mapper.apply((Object)e.key)).stream().map((? super T k) -> UberMaps.entry(k, entry.val))).toMap());
    }

    @Override
    public IntStream flatMapToInt(Function<? super UberMaps.Entry<K, V>, ? extends IntStream> mapper) {
        return this.getActual().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super UberMaps.Entry<K, V>, ? extends LongStream> mapper) {
        return this.getActual().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super UberMaps.Entry<K, V>, ? extends DoubleStream> mapper) {
        return this.getActual().flatMapToDouble(mapper);
    }

    public MapStream<K, V> distinct() {
        return new MapStream<K, V>(this.getActual().distinct());
    }

    public MapStream<K, V> distinctValues() {
        HashSet set = new HashSet();
        return this.filterValue(set::add);
    }

    public MapStream<K, V> sorted() {
        return new MapStream<K, V>(this.getActual().sorted());
    }

    public MapStream<K, V> sorted(Comparator<? super UberMaps.Entry<K, V>> comparator) {
        return new MapStream<K, V>(this.getActual().sorted(comparator));
    }

    public MapStream<K, V> sortedKeys(Comparator<? super K> comparator) {
        return this.sorted(Map.Entry.comparingByKey(comparator));
    }

    public MapStream<K, V> sortedValues(Comparator<? super V> comparator) {
        return this.sorted(Map.Entry.comparingByValue(comparator));
    }

    public MapStream<K, V> peek(Consumer<? super UberMaps.Entry<K, V>> action) {
        return new MapStream<K, V>(this.getActual().peek(action));
    }

    public MapStream<K, V> peekKeys(Consumer<? super K> action) {
        return this.peek((T e) -> action.accept((Object)e.key));
    }

    public MapStream<K, V> peekValues(Consumer<? super V> action) {
        return this.peek((T e) -> action.accept((Object)e.val));
    }

    public MapStream<K, V> limit(long maxSize) {
        return new MapStream<K, V>(this.getActual().limit(maxSize));
    }

    public MapStream<K, V> skip(long n) {
        return new MapStream<K, V>(this.getActual().skip(n));
    }

    @Override
    public void forEach(Consumer<? super UberMaps.Entry<K, V>> action) {
        this.getActual().forEach(action);
    }

    public void forEach(BiConsumer<K, V> action) {
        this.forEach((Consumer<? super UberMaps.Entry<K, V>>)((Consumer<UberMaps.Entry>)e -> action.accept(e.key, e.val)));
    }

    public void forEachKey(Consumer<? super K> action) {
        this.getActual().forEach((? super T e) -> action.accept((Object)e.key));
    }

    public void forEachValue(Consumer<? super V> action) {
        this.getActual().forEach((? super T e) -> action.accept((Object)e.val));
    }

    @Override
    public void forEachOrdered(Consumer<? super UberMaps.Entry<K, V>> action) {
        this.getActual().forEachOrdered(action);
    }

    public UberStream<K> toKeys() {
        return this.map(UberMaps.Entry::getKey);
    }

    public UberStream<V> toValues() {
        return this.map(UberMaps.Entry::getValue);
    }

    @Override
    public Object[] toArray() {
        return this.getActual().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.getActual().toArray(generator);
    }

    @Override
    public UberMaps.Entry<K, V> reduce(UberMaps.Entry<K, V> identity, BinaryOperator<UberMaps.Entry<K, V>> accumulator) {
        return this.getActual().reduce(identity, accumulator);
    }

    @Override
    public Optional<UberMaps.Entry<K, V>> reduce(BinaryOperator<UberMaps.Entry<K, V>> accumulator) {
        return this.getActual().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super UberMaps.Entry<K, V>, U> accumulator, BinaryOperator<U> combiner) {
        return this.getActual().reduce(identity, accumulator, combiner);
    }

    public Map<K, V> toMap() {
        return this.getActual().collect(MapCollectors.toMap());
    }

    public Map<K, V> toLinkedMap() {
        return this.to(LinkedHashMap::new);
    }

    public <M extends Map<K, V>> M to(Supplier<M> mapSupplier) {
        return (M)((Map)this.getActual().collect(MapCollectors.toMap(mapSupplier)));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super UberMaps.Entry<K, V>> accumulator, BiConsumer<R, R> combiner) {
        return this.getActual().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super UberMaps.Entry<K, V>, A, R> collector) {
        return this.getActual().collect(collector);
    }

    @Override
    public Optional<UberMaps.Entry<K, V>> min(Comparator<? super UberMaps.Entry<K, V>> comparator) {
        return this.getActual().min(comparator);
    }

    @Override
    public Optional<UberMaps.Entry<K, V>> max(Comparator<? super UberMaps.Entry<K, V>> comparator) {
        return this.getActual().max(comparator);
    }

    @Override
    public long count() {
        return this.getActual().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return this.getActual().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return this.getActual().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return this.getActual().noneMatch(predicate);
    }

    @Override
    public Optional<UberMaps.Entry<K, V>> findFirst() {
        return this.getActual().findFirst();
    }

    @Override
    public Optional<UberMaps.Entry<K, V>> findAny() {
        return this.getActual().findAny();
    }

    public Optional<UberMaps.Entry<K, V>> find(Predicate<? super UberMaps.Entry<K, V>> predicate) {
        return ((MapStream)this.filter((Predicate)predicate)).findFirst();
    }

    public Optional<UberMaps.Entry<K, V>> findKey(Predicate<? super K> keyPredicate) {
        return this.filterKey(keyPredicate).findFirst();
    }

    public Optional<UberMaps.Entry<K, V>> findByKey(K key) {
        return this.findKey(Predicate.isEqual(key));
    }
}

