/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.whaka.util.function.Tuple2;
import org.whaka.util.function.Tuple3;

@FunctionalInterface
public interface Predicate3<A, B, C> {
    public boolean test(A var1, B var2, C var3);

    public static <A, B, C> Predicate<Tuple3<A, B, C>> toPredicate(Predicate3<A, B, C> delegate) {
        return e -> delegate.test(e._1, e._2, e._3);
    }

    public static <A, B, C> BiPredicate<A, Tuple2<B, C>> toBiPredicate(Predicate3<A, B, C> delegate) {
        return (a, e) -> delegate.test(a, e._1, e._2);
    }

    default public Predicate3<A, B, C> and(Predicate3<? super A, ? super B, ? super C> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c) -> this.test(a, b, c) && other.test(a, b, c);
    }

    default public Predicate3<A, B, C> or(Predicate3<? super A, ? super B, ? super C> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c) -> this.test(a, b, c) || other.test(a, b, c);
    }

    public static <A, B, C> Predicate3<A, B, C> not(Predicate3<A, B, C> delegate) {
        Objects.requireNonNull(delegate, "Negated predicate cannot be null!");
        return (a, b, c) -> !delegate.test(a, b, c);
    }
}

