/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.whaka.util.function.Tuple3;
import org.whaka.util.function.Tuple4;

@FunctionalInterface
public interface Predicate4<A, B, C, D> {
    public boolean test(A var1, B var2, C var3, D var4);

    public static <A, B, C, D> Predicate<Tuple4<A, B, C, D>> toPredicate(Predicate4<A, B, C, D> delegate) {
        return e -> delegate.test(e._1, e._2, e._3, e._4);
    }

    public static <A, B, C, D> BiPredicate<A, Tuple3<B, C, D>> toBiPredicate(Predicate4<A, B, C, D> delegate) {
        return (a, e) -> delegate.test(a, e._1, e._2, e._3);
    }

    default public Predicate4<A, B, C, D> and(Predicate4<? super A, ? super B, ? super C, ? super D> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c, d) -> this.test(a, b, c, d) && other.test(a, b, c, d);
    }

    default public Predicate4<A, B, C, D> or(Predicate4<? super A, ? super B, ? super C, ? super D> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c, d) -> this.test(a, b, c, d) || other.test(a, b, c, d);
    }

    public static <A, B, C, D> Predicate4<A, B, C, D> not(Predicate4<A, B, C, D> delegate) {
        Objects.requireNonNull(delegate, "Negated predicate cannot be null!");
        return (a, b, c, d) -> !delegate.test(a, b, c, d);
    }
}

