/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.whaka.util.function.Tuple4;
import org.whaka.util.function.Tuple5;

@FunctionalInterface
public interface Predicate5<A, B, C, D, E> {
    public boolean test(A var1, B var2, C var3, D var4, E var5);

    public static <A, B, C, D, E> Predicate<Tuple5<A, B, C, D, E>> toPredicate(Predicate5<A, B, C, D, E> delegate) {
        return e -> delegate.test(e._1, e._2, e._3, e._4, e._5);
    }

    public static <A, B, C, D, E> BiPredicate<A, Tuple4<B, C, D, E>> toBiPredicate(Predicate5<A, B, C, D, E> delegate) {
        return (a, e) -> delegate.test(a, e._1, e._2, e._3, e._4);
    }

    default public Predicate5<A, B, C, D, E> and(Predicate5<? super A, ? super B, ? super C, ? super D, ? super E> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c, d, e) -> this.test(a, b, c, d, e) && other.test(a, b, c, d, e);
    }

    default public Predicate5<A, B, C, D, E> or(Predicate5<? super A, ? super B, ? super C, ? super D, ? super E> other) {
        Objects.requireNonNull(other, "Chained predicate cannot be null!");
        return (a, b, c, d, e) -> this.test(a, b, c, d, e) || other.test(a, b, c, d, e);
    }

    public static <A, B, C, D, E> Predicate5<A, B, C, D, E> not(Predicate5<A, B, C, D, E> delegate) {
        Objects.requireNonNull(delegate, "Negated predicate cannot be null!");
        return (a, b, c, d, e) -> !delegate.test(a, b, c, d, e);
    }
}

