/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.function;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.whaka.util.UberMaps;
import org.whaka.util.UberPredicates;
import org.whaka.util.function.MapCollectors;
import org.whaka.util.function.MapStream;

public class UberStream<T>
implements Stream<T> {
    private final Stream<T> actual;

    public UberStream(Stream<T> actual) {
        this.actual = Objects.requireNonNull(actual, "Actual stream cannot be null!");
    }

    private Stream<T> getActual() {
        return this.actual;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getActual().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.getActual().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.getActual().isParallel();
    }

    @Override
    public UberStream<T> sequential() {
        return new UberStream<T>((Stream)this.getActual().sequential());
    }

    @Override
    public UberStream<T> parallel() {
        return new UberStream<T>((Stream)this.getActual().parallel());
    }

    @Override
    public UberStream<T> unordered() {
        return new UberStream<T>((Stream)this.getActual().unordered());
    }

    @Override
    public UberStream<T> onClose(Runnable closeHandler) {
        return new UberStream<T>((Stream)this.getActual().onClose(closeHandler));
    }

    @Override
    public void close() {
        this.getActual().close();
    }

    @Override
    public UberStream<T> filter(Predicate<? super T> predicate) {
        return new UberStream<T>(this.getActual().filter(predicate));
    }

    public <R extends T> UberStream<R> filterByClass(Class<R> filteredClass) {
        Predicate[] predicateArray = new Predicate[2];
        predicateArray[0] = Objects::isNull;
        predicateArray[1] = filteredClass::isInstance;
        return ((UberStream)this.filter(UberPredicates.anyOf(predicateArray))).map(filteredClass::cast);
    }

    public UberStream<T> drop(Predicate<? super T> predicate) {
        return new UberStream<T>(this.getActual().filter(UberPredicates.not(predicate)));
    }

    public UberStream<T> dropNulls() {
        return this.filter(Objects::nonNull);
    }

    public Optional<T> find(Predicate<? super T> predicate) {
        return ((UberStream)this.filter((Predicate)predicate)).findFirst();
    }

    @Override
    public <R> UberStream<R> map(Function<? super T, ? extends R> mapper) {
        return new UberStream<R>(this.getActual().map(mapper));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.getActual().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.getActual().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.getActual().mapToDouble(mapper);
    }

    @Override
    public <R> UberStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new UberStream(this.getActual().flatMap(mapper));
    }

    public <R> UberStream<R> flatMapCol(Function<? super T, ? extends Collection<? extends R>> mapper) {
        return new UberStream(this.getActual().flatMap((? super T t) -> ((Collection)mapper.apply(t)).stream()));
    }

    public <R> UberStream<R> flatMapArr(Function<? super T, R[]> mapper) {
        return new UberStream(this.getActual().flatMap((? super T t) -> Stream.of((Object[])mapper.apply(t))));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.getActual().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.getActual().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.getActual().flatMapToDouble(mapper);
    }

    public <V> UberStream<UberMaps.Entry<T, V>> zip(Function<T, V> mapper) {
        return this.map((T t) -> UberMaps.entry(t, mapper.apply(t)));
    }

    @Override
    public UberStream<T> distinct() {
        return new UberStream<T>(this.getActual().distinct());
    }

    @Override
    public UberStream<T> sorted() {
        return new UberStream<T>(this.getActual().sorted());
    }

    @Override
    public UberStream<T> sorted(Comparator<? super T> comparator) {
        return new UberStream<T>(this.getActual().sorted(comparator));
    }

    @Override
    public UberStream<T> peek(Consumer<? super T> action) {
        return new UberStream<T>(this.getActual().peek(action));
    }

    @Override
    public UberStream<T> limit(long maxSize) {
        return new UberStream<T>(this.getActual().limit(maxSize));
    }

    @Override
    public UberStream<T> skip(long n) {
        return new UberStream<T>(this.getActual().skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.getActual().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.getActual().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.getActual().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.getActual().toArray(generator);
    }

    public <A> A[] toArray(Class<A> type) {
        return this.toArray((int size) -> (Object[])Array.newInstance(type, size));
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.getActual().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.getActual().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.getActual().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.getActual().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.getActual().collect(collector);
    }

    public <C extends Collection<T>> C to(Supplier<C> factory) {
        return (C)((Collection)this.collect(Collectors.toCollection(factory)));
    }

    @Override
    public List<T> toList() {
        return this.collect(Collectors.toList());
    }

    public Set<T> toSet() {
        return this.collect(Collectors.toSet());
    }

    public <K> Map<K, T> toMap(Function<T, K> keyFunction) {
        return this.collect(MapCollectors.toMap(keyFunction, Function.identity()));
    }

    public <K, V> Map<K, V> toMap(Function<T, K> keyFunction, Function<T, V> valFunction) {
        return this.collect(MapCollectors.toMap(keyFunction, valFunction));
    }

    public <K, M extends Map<K, T>> M toMap(Function<T, K> keyFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.collect(MapCollectors.toMap(keyFunction, Function.identity(), mapSupplier)));
    }

    public <K, V, M extends Map<K, V>> M toMap(Function<T, K> keyFunction, Function<T, V> valFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.collect(MapCollectors.toMap(keyFunction, valFunction, mapSupplier)));
    }

    public <K> MapStream<K, T> toMapStream(Function<T, K> keyFunction) {
        return this.toMapStream(keyFunction, x -> x);
    }

    public <K, V> MapStream<K, V> toMapStream(Function<T, K> keyFunction, Function<T, V> valFunction) {
        return new MapStream(this.map((T t) -> UberMaps.entry(keyFunction.apply(t), valFunction.apply(t))));
    }

    public String join(CharSequence delimiter) {
        return this.join(delimiter, "", "");
    }

    public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return ((UberStream)this.map(String::valueOf)).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.getActual().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.getActual().max(comparator);
    }

    @Override
    public long count() {
        return this.getActual().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.getActual().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.getActual().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.getActual().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.getActual().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.getActual().findAny();
    }
}

