/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.whaka.util.UberStreams;
import org.whaka.util.function.UberStream;

public class UberClasses {
    private UberClasses() {
    }

    public static boolean descends(Class<?> a, Class<?> b) {
        return b.isAssignableFrom(a) && a != b;
    }

    public static UberStream<Class<?>> streamAncestors(Class<?> type) {
        return UberStreams.iterate(type, Class::getSuperclass, Objects::nonNull);
    }

    public static UberStream<Class<?>> streamInterfaces(Class<?> type) {
        return UberStreams.stream(Stream.concat(Stream.of(type), Stream.of(type.getInterfaces())));
    }

    public static UberStream<Class<?>> streamTypeLinearization(Class<?> type) {
        return UberStreams.stream(UberClasses.linearization(type));
    }

    private static Set<Class<?>> linearization(Class<?> type) {
        if (type == null) {
            return Collections.emptySet();
        }
        LinkedHashSet set = new LinkedHashSet(Collections.singleton(type));
        for (Class<?> iface : type.getInterfaces()) {
            set.addAll(UberClasses.linearization(iface));
        }
        set.addAll(UberClasses.linearization(type.getSuperclass()));
        return set;
    }

    public static <T> Class<T> cast(Class type) {
        return type;
    }
}

