/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.whaka.util.reflection.UberClasses;
import org.whaka.util.reflection.Visibility;

public class UberMethods {
    public static Visibility getVisibility(Method m) {
        return Visibility.getFromModifiers(m.getModifiers());
    }

    public static boolean isFinal(Method m) {
        return Modifier.isFinal(m.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean overrides(Method a, Method b) {
        if (UberMethods.isFinal(b) || UberMethods.getVisibility(b).isPrivate()) {
            return false;
        }
        if (!UberMethods.isEqualPackage(a, b) && UberMethods.getVisibility(b).isDefault()) {
            return false;
        }
        if (!UberMethods.isEqualSignature(a, b)) {
            return false;
        }
        return UberClasses.descends(a.getDeclaringClass(), b.getDeclaringClass());
    }

    public static boolean isEqualPackage(Method a, Method b) {
        return a.getDeclaringClass().getPackage() == b.getDeclaringClass().getPackage();
    }

    public static boolean isEqualSignature(Method a, Method b) {
        return a.getName().equals(b.getName()) && Arrays.equals(a.getParameterTypes(), b.getParameterTypes());
    }
}

