/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison;

import java.util.Objects;
import java.util.function.BiPredicate;
import org.whaka.util.DoubleMath;
import org.whaka.util.reflection.UberMethods;
import org.whaka.util.reflection.Visibility;
import org.whaka.util.reflection.comparison.ComparisonFail;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.performers.AbstractComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.ArrayComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.GettersDynamicPerformerBuilder;
import org.whaka.util.reflection.comparison.performers.ListComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.MapComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.PropertyDynamicPerformerBuilder;
import org.whaka.util.reflection.comparison.performers.ReflectiveComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.SetComparisonPerformer;

public class ComparisonPerformers {
    public static final ComparisonPerformer<Object> DEEP_EQUALS = new AbstractComparisonPerformer<Object>("DeepEquals"){

        @Override
        public ComparisonResult apply(Object actual, Object expected) {
            return new ComparisonResult(actual, expected, this, Objects.deepEquals(actual, expected));
        }
    };
    public static final ComparisonPerformer<Number> DOUBLE_MATH_EQUALS = new AbstractComparisonPerformer<Number>("DoubleMath"){

        @Override
        public ComparisonResult apply(Number actual, Number expected) {
            if (actual == expected) {
                return new ComparisonResult(actual, expected, this, true);
            }
            if (actual == null || expected == null) {
                return new ComparisonResult(actual, expected, this, false);
            }
            boolean equals = DoubleMath.equals(actual.doubleValue(), expected.doubleValue());
            return new ComparisonResult(actual, expected, this, equals);
        }
    };
    public static final ReflectiveComparisonPerformer REFLECTIVE_EQUALS = new ReflectiveComparisonPerformer();

    private ComparisonPerformers() {
    }

    public static <T> ComparisonPerformer<T> fromPredicate(final BiPredicate<T, T> predicate) {
        return new AbstractComparisonPerformer<T>("PredicateCompare:" + predicate){

            @Override
            public ComparisonResult apply(T actual, T expected) {
                return new ComparisonResult(actual, expected, this, predicate.test(actual, expected));
            }
        };
    }

    public static <T> ArrayComparisonPerformer<T> array(ComparisonPerformer<? super T> elementPerformer) {
        return new ArrayComparisonPerformer<T>(elementPerformer);
    }

    public static <T> ListComparisonPerformer<T> list(ComparisonPerformer<T> elementPerformer) {
        return new ListComparisonPerformer<T>(elementPerformer);
    }

    public static <T> SetComparisonPerformer<T> set(ComparisonPerformer<? super T> elementPerformer) {
        return new SetComparisonPerformer<T>(elementPerformer);
    }

    public static <T> MapComparisonPerformer<T> map(ComparisonPerformer<? super T> elementPerformer) {
        return new MapComparisonPerformer<T>(elementPerformer);
    }

    public static <T> PropertyDynamicPerformerBuilder<T> buildProperties(Class<T> type) {
        return new PropertyDynamicPerformerBuilder<T>(type);
    }

    public static <T> GettersDynamicPerformerBuilder<T> buildGetters(Class<T> type) {
        return new GettersDynamicPerformerBuilder<T>(type).addRequirement(m -> UberMethods.getVisibility(m) == Visibility.PUBLIC).addExcludingFilter("clone|getClass|hashCode|toString");
    }

    public static <T> ComparisonResult safePerform(T actual, T expected, ComparisonPerformer<? super T> performer) {
        Objects.requireNonNull(performer, "Comparison performer cannot be null!");
        try {
            return performer.apply((Object)actual, (Object)expected);
        }
        catch (Throwable e) {
            return new ComparisonFail(actual, expected, performer, e);
        }
    }
}

