/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.whaka.util.UberObjects;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.properties.ClassPropertyKey;
import org.whaka.util.reflection.properties.ClassPropertyStack;

public class ComplexComparisonResult
extends ComparisonResult {
    private final Map<ClassPropertyKey, ComparisonResult> propertyResults = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();

    public ComplexComparisonResult(Object actual, Object expected, ComparisonPerformer<?> comparisonPerformer, Map<ClassPropertyKey, ComparisonResult> unequalProperties) {
        super(actual, expected, comparisonPerformer, true);
        if (unequalProperties != null) {
            Preconditions.checkArgument((!unequalProperties.containsKey(null) ? 1 : 0) != 0, (Object)"Property key cannot be null!");
            this.propertyResults.putAll(unequalProperties);
        }
    }

    public Map<ClassPropertyKey, ComparisonResult> getPropertyResults() {
        return Collections.unmodifiableMap(this.propertyResults);
    }

    public Map<ClassPropertyStack, ComparisonResult> flatten() {
        return this.flatten(null);
    }

    public Map<ClassPropertyStack, ComparisonResult> flatten(ClassPropertyStack parent) {
        LinkedHashMap<ClassPropertyStack, ComparisonResult> map = new LinkedHashMap<ClassPropertyStack, ComparisonResult>();
        for (Map.Entry<ClassPropertyKey, ComparisonResult> e : this.getPropertyResults().entrySet()) {
            ClassPropertyStack stack = new ClassPropertyStack(parent, e.getKey());
            ComparisonResult result = e.getValue();
            if (result instanceof ComplexComparisonResult) {
                map.putAll(((ComplexComparisonResult)result).flatten(stack));
                continue;
            }
            map.put(stack, result);
        }
        return map;
    }

    @Override
    public boolean isSuccess() {
        return this.getPropertyResults().values().stream().filter(Objects::nonNull).allMatch(ComparisonResult::isSuccess);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ComplexComparisonResult.class).add("success", this.isSuccess()).add("property-results", this.getPropertyResults().keySet()).add("actual", (Object)UberObjects.toString(this.getActual())).add("expected", (Object)UberObjects.toString(this.getExpected())).add("performer", this.getComparisonPerformer()).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getActual(), this.getExpected(), this.getComparisonPerformer(), this.getPropertyResults());
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ComplexComparisonResult that = (ComplexComparisonResult)object;
            return this.getActual() == that.getActual() && this.getExpected() == that.getExpected() && Objects.equals(this.getComparisonPerformer(), that.getComparisonPerformer()) && Objects.equals(this.getPropertyResults(), that.getPropertyResults());
        }
        return false;
    }
}

