/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonPerformers;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class ComplexComparisonResultBuilder<T> {
    private final Map<ClassPropertyKey, ComparisonResult> propertyResults = new HashMap<ClassPropertyKey, ComparisonResult>();
    private final Class<? super T> type;
    private ComparisonPerformer<Object> defaultComparisonPerformer = ComparisonPerformers.DEEP_EQUALS;

    public ComplexComparisonResultBuilder(Class<? super T> type) {
        this.type = type;
    }

    public ClassPropertyKey createKey(String name) {
        return new ClassPropertyKey(name, this.type);
    }

    public Class<?> getType() {
        return this.type;
    }

    public ComplexComparisonResultBuilder<T> setDefaultComparisonPerformer(ComparisonPerformer<Object> defaultComparisonPerformer) {
        this.defaultComparisonPerformer = Objects.requireNonNull(defaultComparisonPerformer, "Default comparison performer cannot be null!");
        return this;
    }

    public ComparisonPerformer<Object> getDefaultComparisonPerformer() {
        return this.defaultComparisonPerformer;
    }

    public Map<ClassPropertyKey, ComparisonResult> getPropertyResults() {
        return this.propertyResults;
    }

    public ComplexComparisonResultBuilder<T> apply(String propertyName, Object actual, Object expected) {
        return this.apply(propertyName, actual, expected, this.getDefaultComparisonPerformer());
    }

    public <X> ComplexComparisonResultBuilder<T> apply(String propertyName, X actual, X expected, ComparisonPerformer<? super X> performer) {
        this.addResult(propertyName, (ComparisonResult)performer.apply((Object)actual, (Object)expected));
        return this;
    }

    public ComplexComparisonResultBuilder<T> addResult(String propertyName, ComparisonResult result) {
        this.propertyResults.put(this.createKey(propertyName), result);
        return this;
    }

    public ComplexComparisonResult build(T actual, T expected, ComparisonPerformer<? super T> performer) {
        return new ComplexComparisonResult(actual, expected, performer, this.propertyResults);
    }
}

