/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import java.util.LinkedHashMap;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResultBuilder;
import org.whaka.util.reflection.comparison.performers.ContainerComparisonPerformer;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class ArrayComparisonPerformer<T>
extends ContainerComparisonPerformer<T, T[]> {
    public ArrayComparisonPerformer(ComparisonPerformer<? super T> elementPerformer) {
        super(elementPerformer);
    }

    @Override
    public ComparisonResult apply(T[] actual, T[] expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        if (actual.length != expected.length) {
            return this.createLengthCheckResult(actual, expected);
        }
        return this.performElementsComparison(actual, expected);
    }

    private ComparisonResult createLengthCheckResult(T[] actual, T[] expected) {
        return new ComplexComparisonResultBuilder<Object[]>(Object[].class).apply("length", actual.length, expected.length).build(actual, expected, this);
    }

    private ComparisonResult performElementsComparison(T[] actual, T[] expected) {
        LinkedHashMap<ClassPropertyKey, ComparisonResult> results = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        for (int i = 0; i < actual.length; ++i) {
            T actualElement = actual[i];
            T expectedElement = expected[i];
            Object result = this.getElementPerformer().apply((Object)actualElement, (Object)expectedElement);
            results.put(ArrayComparisonPerformer.createKey(i), (ComparisonResult)result);
        }
        return new ComplexComparisonResult(actual, expected, this, results);
    }

    private static ClassPropertyKey createKey(int index) {
        return new ClassPropertyKey(index, Object[].class);
    }
}

