/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.performers.AbstractComparisonPerformer;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class CompositeComparisonPerformer<T>
extends AbstractComparisonPerformer<T> {
    private final Map<ClassPropertyKey, ComparisonPerformer<T>> performers = new LinkedHashMap<ClassPropertyKey, ComparisonPerformer<T>>();

    public CompositeComparisonPerformer(String name, Map<ClassPropertyKey, ComparisonPerformer<T>> performers) {
        super(name);
        if (performers != null) {
            Preconditions.checkArgument((!performers.containsKey(null) ? 1 : 0) != 0, (Object)"Class property key cannot be null!");
            Preconditions.checkArgument((!performers.containsValue(null) ? 1 : 0) != 0, (Object)"Property comparison performer cannot be null!");
            this.performers.putAll(performers);
        }
    }

    public Map<ClassPropertyKey, ComparisonPerformer<T>> getPerformers() {
        return this.performers;
    }

    @Override
    public ComparisonResult apply(T actual, T expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        LinkedHashMap<ClassPropertyKey, ComparisonResult> results = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        for (Map.Entry<ClassPropertyKey, ComparisonPerformer<T>> e : this.getPerformers().entrySet()) {
            Object result = e.getValue().apply((Object)actual, (Object)expected);
            results.put(e.getKey(), (ComparisonResult)result);
        }
        return new ComplexComparisonResult(actual, expected, this, results);
    }
}

