/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonPerformers;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.performers.AbstractComparisonPerformer;

public class DynamicComparisonPerformer
extends AbstractComparisonPerformer<Object> {
    private final Map<Class<?>, ComparisonPerformer<?>> registeredDelegates = new LinkedHashMap();
    private final Map<Class<? extends Collection<?>>, Map<Class<?>, Function<?, ?>>> collectionDelegateProviders = new LinkedHashMap();
    private final Map<Class<? extends Map<?, ?>>, Map<Class<?>, Function<?, ?>>> mapDelegateProviders = new LinkedHashMap();
    private final Map<Class<?>, Function<?, ?>> arrayDelegateProviders = new LinkedHashMap();
    private ComparisonPerformer<Object> defaultDelegate = ComparisonPerformers.DEEP_EQUALS;

    public DynamicComparisonPerformer() {
        super("DynamicCompare");
    }

    public ComparisonPerformer<?> getDelegate(Object actual, Object expected) {
        ComparisonPerformer<?> registered = this.findRegisteredDelegate(actual, expected);
        return registered == null ? this.getDefaultDelegate() : registered;
    }

    public void setDefaultDelegate(ComparisonPerformer<Object> defaultDelegate) {
        Objects.requireNonNull(defaultDelegate, "Default delegate cannot be null!");
        Preconditions.checkArgument((defaultDelegate != this ? 1 : 0) != 0, (Object)"Dynamic performer cannot be used as it's own default delegate!");
        this.defaultDelegate = defaultDelegate;
    }

    public ComparisonPerformer<Object> getDefaultDelegate() {
        return this.defaultDelegate;
    }

    public <V> DynamicComparisonPerformer registerDelegate(Class<V> valueType, ComparisonPerformer<? super V> delegate) {
        this.registeredDelegates.put(valueType, delegate);
        return this;
    }

    public Map<Class<?>, ComparisonPerformer<?>> getRegisteredDelegates() {
        return this.registeredDelegates;
    }

    public <V> DynamicComparisonPerformer registerArrayDelegateProvider(Class<V> arrayType, Function<ComparisonPerformer<? super V>, ComparisonPerformer<? super V[]>> provider) {
        Preconditions.checkArgument((boolean)Object[].class.isAssignableFrom(arrayType), (Object)"Array performer provider can be registered only for a type derived from Object[]!");
        this.arrayDelegateProviders.put(arrayType, provider);
        return this;
    }

    public Map<Class<?>, Function<?, ?>> getArrayDelegateProviders() {
        return this.arrayDelegateProviders;
    }

    public <V, C extends Collection<?>> DynamicComparisonPerformer registerCollectionDelegateProvider(Class<C> collectionType, Class<V> valueType, Function<ComparisonPerformer<V>, ComparisonPerformer<? super C>> provider) {
        this.collectionDelegateProviders.computeIfAbsent(collectionType, c -> new LinkedHashMap()).put(valueType, provider);
        return this;
    }

    public Map<Class<? extends Collection<?>>, Map<Class<?>, Function<?, ?>>> getCollectionDelegateProviders() {
        return this.collectionDelegateProviders;
    }

    public <V, M extends Map<?, V>> DynamicComparisonPerformer registerMapDelegateProvider(Class<M> mapType, Class<V> valueType, Function<ComparisonPerformer<V>, ComparisonPerformer<? super M>> provider) {
        this.mapDelegateProviders.computeIfAbsent(mapType, c -> new LinkedHashMap()).put(valueType, provider);
        return this;
    }

    public Map<Class<? extends Map<?, ?>>, Map<Class<?>, Function<?, ?>>> getMapDelegateProviders() {
        return this.mapDelegateProviders;
    }

    public ComparisonPerformer<?> findRegisteredDelegate(Object actual, Object expected) {
        if (actual == null || expected == null) {
            return null;
        }
        for (Map.Entry<Class<?>, ComparisonPerformer<?>> e : this.getRegisteredDelegates().entrySet()) {
            if (!e.getKey().isInstance(actual) || !e.getKey().isInstance(expected)) continue;
            return e.getValue();
        }
        if (actual instanceof Object[] && expected instanceof Object[]) {
            return this.createArrayDelegate((Object[])actual, (Object[])expected);
        }
        if (actual instanceof Collection && expected instanceof Collection) {
            return this.createCollectionDelegate((Collection)actual, (Collection)expected);
        }
        if (actual instanceof Map && expected instanceof Map) {
            return this.createMapDelegate((Map)actual, (Map)expected);
        }
        return null;
    }

    private ComparisonPerformer<?> createArrayDelegate(Object[] actual, Object[] expected) {
        Function<ComparisonPerformer, ComparisonPerformer> provider = this.findArrayDelegateProvider(actual, expected);
        return provider.apply(this);
    }

    private Function<ComparisonPerformer, ComparisonPerformer> findArrayDelegateProvider(Object[] actual, Object[] expected) {
        Function provider = this.getArrayDelegateProviders().entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(actual) && ((Class)e.getKey()).isInstance(expected)).map(Map.Entry::getValue).findFirst().orElse(null);
        return provider == null ? ComparisonPerformers::array : provider;
    }

    private ComparisonPerformer<?> createCollectionDelegate(Collection<?> actual, Collection<?> expected) {
        Function<ComparisonPerformer, ComparisonPerformer> provider = this.findCollectionDelegateProvider(actual, expected);
        return provider.apply(this);
    }

    private Function<ComparisonPerformer, ComparisonPerformer> findCollectionDelegateProvider(Collection<?> actual, Collection<?> expected) {
        Function<?, ?> provider = this.getProviderForCollectionElementsType(actual, expected);
        return provider == null ? ComparisonPerformers::set : provider;
    }

    private Function<?, ?> getProviderForCollectionElementsType(Collection<?> actual, Collection<?> expected) {
        BiPredicate<Collection, Class> allElementsMatch = (col, type) -> col.stream().allMatch(type::isInstance);
        Predicate<Class> bothCollectionsMatch = c -> allElementsMatch.test(actual, (Class)c) && allElementsMatch.test(expected, (Class)c);
        return this.getProvidersForSpecificCollectionType(actual, expected).entrySet().stream().filter(e -> bothCollectionsMatch.test((Class)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private Map<Class<?>, Function<?, ?>> getProvidersForSpecificCollectionType(Collection<?> actual, Collection<?> expected) {
        return this.getCollectionDelegateProviders().entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(actual) && ((Class)e.getKey()).isInstance(expected)).map(Map.Entry::getValue).findFirst().orElseGet(Collections::emptyMap);
    }

    private ComparisonPerformer<?> createMapDelegate(Map<?, ?> actual, Map<?, ?> expected) {
        Function<ComparisonPerformer, ComparisonPerformer> provider = this.findMapDelegateProvider(actual, expected);
        return provider.apply(this);
    }

    private Function<ComparisonPerformer, ComparisonPerformer> findMapDelegateProvider(Map<?, ?> actual, Map<?, ?> expected) {
        Function<?, ?> provider = this.getProviderForMapElementsType(actual, expected);
        return provider == null ? ComparisonPerformers::map : provider;
    }

    private Function<?, ?> getProviderForMapElementsType(Map<?, ?> actual, Map<?, ?> expected) {
        BiPredicate<Map, Class> allElementsMatch = (map, type) -> map.values().stream().allMatch(type::isInstance);
        Predicate<Class> bothCollectionsMatch = c -> allElementsMatch.test(actual, (Class)c) && allElementsMatch.test(expected, (Class)c);
        return this.getProvidersForSpecificMapType(actual, expected).entrySet().stream().filter(e -> bothCollectionsMatch.test((Class)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private Map<Class<?>, Function<?, ?>> getProvidersForSpecificMapType(Map<?, ?> actual, Map<?, ?> expected) {
        return this.getMapDelegateProviders().entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(actual) && ((Class)e.getKey()).isInstance(expected)).map(Map.Entry::getValue).findFirst().orElseGet(Collections::emptyMap);
    }

    @Override
    public ComparisonResult apply(Object actual, Object expected) {
        ComparisonPerformer<?> delegate = this.getDelegate(actual, expected);
        return delegate.apply(actual, expected);
    }
}

