/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.whaka.util.UberPredicates;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.AbstractDynamicPerformerBuilder;
import org.whaka.util.reflection.comparison.performers.CompositeComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.PropertyDelegatePerformer;
import org.whaka.util.reflection.properties.ClassProperty;
import org.whaka.util.reflection.properties.ClassPropertyExtractor;
import org.whaka.util.reflection.properties.ClassPropertyKey;
import org.whaka.util.reflection.properties.GetterClassProperty;
import org.whaka.util.reflection.properties.GettersExtractor;

public class GettersDynamicPerformerBuilder<T>
extends AbstractDynamicPerformerBuilder<T, CompositeComparisonPerformer<T>> {
    public static final String DEFAULT_METHODS = "clone|getClass|hashCode|toString";
    private final AtomicBoolean buildFinished = new AtomicBoolean();
    private final ClassPropertyExtractor<GetterClassProperty<?, ?>> gettersExtractor;
    private final Set<Predicate<Method>> requirementFilters = new LinkedHashSet<Predicate<Method>>();
    private final Set<Predicate<Method>> includingFilters = new LinkedHashSet<Predicate<Method>>();
    private final Set<Predicate<Method>> excludingFilters = new LinkedHashSet<Predicate<Method>>();

    public GettersDynamicPerformerBuilder(Class<T> type) {
        this(type, new GettersExtractor());
    }

    public GettersDynamicPerformerBuilder(Class<T> type, ClassPropertyExtractor<GetterClassProperty<?, ?>> gettersExtractor) {
        super(type);
        this.gettersExtractor = Objects.requireNonNull(gettersExtractor, "Getters extractor cannot be null!");
    }

    public ClassPropertyExtractor<GetterClassProperty<?, ?>> getGettersExtractor() {
        return this.gettersExtractor;
    }

    public Set<Predicate<Method>> getRequirementFilters() {
        return this.requirementFilters;
    }

    public Set<Predicate<Method>> getIncludingFilters() {
        return this.includingFilters;
    }

    public Set<Predicate<Method>> getExcludingFilters() {
        return this.excludingFilters;
    }

    public GettersDynamicPerformerBuilder<T> addFilter(String pattern) {
        return this.addFilter(new PatternPredicate(pattern));
    }

    public GettersDynamicPerformerBuilder<T> addExcludingFilter(String pattern) {
        return this.addExcludingFilter(new PatternPredicate(pattern));
    }

    public GettersDynamicPerformerBuilder<T> addRequirement(Predicate<Method> filter) {
        Objects.requireNonNull(filter, "Property filter cannot be null!");
        this.getRequirementFilters().add(filter);
        return this;
    }

    public GettersDynamicPerformerBuilder<T> addFilter(Predicate<Method> filter) {
        Objects.requireNonNull(filter, "Property filter cannot be null!");
        this.getIncludingFilters().add(filter);
        return this;
    }

    public GettersDynamicPerformerBuilder<T> addExcludingFilter(Predicate<Method> filter) {
        Objects.requireNonNull(filter, "Property filter cannot be null!");
        this.getExcludingFilters().add(filter);
        return this;
    }

    @Override
    public CompositeComparisonPerformer<T> build(String name) {
        if (!this.buildFinished.compareAndSet(false, true)) {
            throw new IllegalStateException("Due to the dynamic delegate nature builder cannot be used twice!");
        }
        CompositeComparisonPerformer<T> performer = new CompositeComparisonPerformer<T>(name, this.buildPerformers());
        if (!this.getDynamicPerformer().getRegisteredDelegates().containsKey(this.getType())) {
            this.getDynamicPerformer().registerDelegate(this.getType(), performer);
        }
        return performer;
    }

    private Map<ClassPropertyKey, ComparisonPerformer<T>> buildPerformers() {
        return this.streamFilteredProperties().collect(Collectors.toMap(ClassProperty::getKey, this::createPerformer));
    }

    private Stream<GetterClassProperty<?, ?>> streamFilteredProperties() {
        return this.getGettersExtractor().extractAll(this.getType()).values().stream().filter(UberPredicates.not(ClassProperty::isStatic)).filter(this.createTotalPredicate());
    }

    private Predicate<GetterClassProperty<?, ?>> createTotalPredicate() {
        Predicate<Method> totalRequired = this.createTotalRequiredPredicate();
        Predicate<Method> totalIncluded = this.createTotalPositivePredicate();
        Predicate<Method> totalExcluded = this.createTotalNegativePredicate();
        Predicate total = UberPredicates.allOf(totalRequired, totalIncluded, totalExcluded);
        return prop -> total.test(prop.getGetter());
    }

    private Predicate<Method> createTotalRequiredPredicate() {
        Set filters = this.getRequirementFilters();
        return filters.isEmpty() ? m -> true : UberPredicates.allOf(filters);
    }

    private Predicate<Method> createTotalPositivePredicate() {
        Set filters = this.getIncludingFilters();
        return filters.isEmpty() ? m -> true : UberPredicates.anyOf(filters);
    }

    private Predicate<Method> createTotalNegativePredicate() {
        Set filters = this.getExcludingFilters();
        return filters.isEmpty() ? m -> true : UberPredicates.noneOf(filters);
    }

    private ComparisonPerformer<T> createPerformer(GetterClassProperty property) {
        return new PropertyDelegatePerformer(property, this.getDynamicPerformer());
    }

    public static class PatternPredicate
    implements Predicate<Method> {
        private final Pattern pattern;

        public PatternPredicate(String pattern) {
            this(Pattern.compile(pattern));
        }

        public PatternPredicate(Pattern pattern) {
            this.pattern = Objects.requireNonNull(pattern, "Pattern cannot be null!");
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public boolean test(Method t) {
            return this.getPattern().matcher(t.getName()).matches();
        }

        public int hashCode() {
            return Objects.hash(this.pattern.flags(), this.pattern.pattern());
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == this.getClass()) {
                PatternPredicate that = (PatternPredicate)obj;
                return Objects.equals(this.getPattern().pattern(), that.getPattern().pattern()) && this.getPattern().flags() == that.getPattern().flags();
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.getPattern().pattern()).add("flags", this.getPattern().flags()).toString();
        }
    }
}

