/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import java.util.LinkedHashMap;
import java.util.List;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResultBuilder;
import org.whaka.util.reflection.comparison.performers.ContainerComparisonPerformer;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class ListComparisonPerformer<T>
extends ContainerComparisonPerformer<T, List<? extends T>> {
    public ListComparisonPerformer(ComparisonPerformer<? super T> elementPerformer) {
        super(elementPerformer);
    }

    @Override
    public ComparisonResult apply(List<? extends T> actual, List<? extends T> expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        if (actual.size() != expected.size()) {
            return this.createSizeCheckResult(actual, expected);
        }
        return this.performElementComparison(actual, expected);
    }

    private ComparisonResult createSizeCheckResult(List<? extends T> actual, List<? extends T> expected) {
        return new ComplexComparisonResultBuilder<List>(List.class).apply("size", actual.size(), expected.size()).build(actual, expected, this);
    }

    private ComparisonResult performElementComparison(List<? extends T> actual, List<? extends T> expected) {
        LinkedHashMap<ClassPropertyKey, ComparisonResult> results = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        for (int i = 0; i < actual.size(); ++i) {
            T actualElement = actual.get(i);
            T expectedElement = expected.get(i);
            Object result = this.getElementPerformer().apply((Object)actualElement, (Object)expectedElement);
            results.put(ListComparisonPerformer.createKey(i), (ComparisonResult)result);
        }
        return new ComplexComparisonResult(actual, expected, this, results);
    }

    private static ClassPropertyKey createKey(int index) {
        return new ClassPropertyKey(index, List.class);
    }
}

