/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResultBuilder;
import org.whaka.util.reflection.comparison.performers.ContainerComparisonPerformer;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class MapComparisonPerformer<V>
extends ContainerComparisonPerformer<V, Map<?, ? extends V>> {
    public MapComparisonPerformer(ComparisonPerformer<? super V> elementPerformer) {
        super(elementPerformer);
    }

    @Override
    public ComparisonResult apply(Map<?, ? extends V> actual, Map<?, ? extends V> expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        if (actual.size() != expected.size()) {
            return this.createSizeCheckResult(actual, expected);
        }
        if (!actual.keySet().equals(expected.keySet())) {
            return this.createKeysCheckResult(actual, expected);
        }
        return this.performElementComparison(actual, expected);
    }

    private ComparisonResult createSizeCheckResult(Map<?, ? extends V> actual, Map<?, ? extends V> expected) {
        return new ComplexComparisonResultBuilder<Map>(Map.class).apply("size", actual.size(), expected.size()).build(actual, expected, this);
    }

    private ComparisonResult createKeysCheckResult(Map<?, ? extends V> actual, Map<?, ? extends V> expected) {
        return new ComplexComparisonResultBuilder<Map>(Map.class).apply("keySet", actual.keySet(), expected.keySet()).build(actual, expected, this);
    }

    private ComparisonResult performElementComparison(Map<?, ? extends V> actual, Map<?, ? extends V> expected) {
        for (Object key : actual.keySet()) {
            Object valueResult = this.getElementPerformer().apply(actual.get(key), expected.get(key));
            if (((ComparisonResult)valueResult).isSuccess()) continue;
            return this.createElementsMatchingResult(actual, expected, key, (ComparisonResult)valueResult);
        }
        return new ComparisonResult(actual, expected, this, true);
    }

    private ComparisonResult createElementsMatchingResult(Map<?, ? extends V> actual, Map<?, ? extends V> expected, Object key, ComparisonResult valueResult) {
        LinkedHashMap<ClassPropertyKey, ComparisonResult> subResults = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        subResults.put(new ClassPropertyKey(key, Map.class), valueResult);
        return new ComplexComparisonResult(actual, expected, this, subResults);
    }
}

