/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.whaka.util.reflection.comparison.ComparisonFail;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.properties.ClassProperty;

class PropertyDelegatePerformer<V, T>
implements ComparisonPerformer<T> {
    private final ClassProperty<V, T> property;
    private final ComparisonPerformer<? super V> delegatePerformer;

    public PropertyDelegatePerformer(ClassProperty<V, T> property, ComparisonPerformer<? super V> delegatePerformer) {
        this.property = Objects.requireNonNull(property, "Property cannot be null!");
        this.delegatePerformer = Objects.requireNonNull(delegatePerformer, "Delegate performer cannot be null!");
    }

    public ClassProperty<V, T> getProperty() {
        return this.property;
    }

    public ComparisonPerformer<? super V> getDelegatePerformer() {
        return this.delegatePerformer;
    }

    @Override
    public ComparisonResult apply(T actual, T expected) {
        V expectedValue;
        V actualValue;
        try {
            actualValue = this.getProperty().getValue(actual);
            expectedValue = this.getProperty().getValue(expected);
        }
        catch (Throwable e) {
            return new ComparisonFail(actual, expected, this, e);
        }
        return this.getDelegatePerformer().apply((Object)actualValue, (Object)expectedValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("property", this.getProperty()).add("delegate", this.getDelegatePerformer()).toString();
    }
}

