/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.AbstractDynamicPerformerBuilder;
import org.whaka.util.reflection.comparison.performers.CompositeComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.PropertyDelegatePerformer;
import org.whaka.util.reflection.properties.ClassProperty;
import org.whaka.util.reflection.properties.ClassPropertyKey;
import org.whaka.util.reflection.properties.FunctionalClassProperty;

public class PropertyDynamicPerformerBuilder<T>
extends AbstractDynamicPerformerBuilder<T, CompositeComparisonPerformer<T>> {
    private final AtomicBoolean buildFinished = new AtomicBoolean();
    private final Map<ClassPropertyKey, ComparisonPerformer<T>> propertyPerformers = new LinkedHashMap<ClassPropertyKey, ComparisonPerformer<T>>();

    public PropertyDynamicPerformerBuilder(Class<T> type) {
        super(type);
    }

    public Map<ClassPropertyKey, ComparisonPerformer<T>> getPropertyPerformers() {
        return this.propertyPerformers;
    }

    public <V> PropertyDynamicPerformerBuilder<T> addProperty(String name, Function<T, V> getter) {
        return this.addProperty(name, getter, this.getDynamicPerformer());
    }

    public <V> PropertyDynamicPerformerBuilder<T> addProperty(ClassProperty<V, T> property) {
        return this.addProperty(property, this.getDynamicPerformer());
    }

    public <V> PropertyDynamicPerformerBuilder<T> addProperty(String name, Function<T, V> getter, ComparisonPerformer<? super V> performer) {
        ClassPropertyKey key = new ClassPropertyKey(name, this.getType());
        FunctionalClassProperty<V, T> property = FunctionalClassProperty.newPublic(key, null, getter);
        return this.addProperty(property, performer);
    }

    public <V> PropertyDynamicPerformerBuilder<T> addProperty(ClassProperty<V, T> property, ComparisonPerformer<? super V> delegate) {
        this.getPropertyPerformers().put(property.getKey(), new PropertyDelegatePerformer<V, T>(property, delegate));
        return this;
    }

    @Override
    public CompositeComparisonPerformer<T> build(String name) {
        if (!this.buildFinished.compareAndSet(false, true)) {
            throw new IllegalStateException("Due to the dynamic delegate nature builder cannot be used twice!");
        }
        CompositeComparisonPerformer<T> performer = new CompositeComparisonPerformer<T>(name, this.getPropertyPerformers());
        if (!this.getDynamicPerformer().getRegisteredDelegates().containsKey(this.getType())) {
            this.getDynamicPerformer().registerDelegate(this.getType(), performer);
        }
        return performer;
    }
}

