/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import com.google.common.primitives.Primitives;
import java.util.LinkedHashMap;
import org.whaka.util.reflection.comparison.ComparisonFail;
import org.whaka.util.reflection.comparison.ComparisonPerformers;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResultBuilder;
import org.whaka.util.reflection.comparison.performers.AbstractComparisonPerformer;
import org.whaka.util.reflection.comparison.performers.ArrayComparisonPerformer;
import org.whaka.util.reflection.properties.ClassProperty;
import org.whaka.util.reflection.properties.ClassPropertyKey;
import org.whaka.util.reflection.properties.FieldsExtractor;

public class ReflectiveComparisonPerformer
extends AbstractComparisonPerformer<Object> {
    public final ArrayComparisonPerformer<Object> ARRAY_DELEGATE = ComparisonPerformers.array(this);
    private final FieldsExtractor fieldsExtractor = new FieldsExtractor();

    public ReflectiveComparisonPerformer() {
        super("ReflectiveEquals");
    }

    @Override
    public ComparisonResult apply(Object actual, Object expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        if (actual.getClass() != expected.getClass()) {
            return this.createClassCheckResult(actual, expected);
        }
        if (ReflectiveComparisonPerformer.isSuitableForDefaultCompare(actual.getClass())) {
            boolean success = ((ComparisonResult)ComparisonPerformers.DEEP_EQUALS.apply(actual, expected)).isSuccess();
            return new ComparisonResult(actual, expected, this, success);
        }
        if (actual instanceof Object[] && expected instanceof Object[]) {
            return this.ARRAY_DELEGATE.apply((Object[])((Object[])actual), (Object[])((Object[])expected));
        }
        return this.performPropertiesComparison(actual, expected);
    }

    private ComparisonResult createClassCheckResult(Object actual, Object expected) {
        return new ComplexComparisonResultBuilder<Object>(Object.class).apply("getClass()", actual.getClass(), expected.getClass(), this).build(actual, expected, this);
    }

    private static boolean isSuitableForDefaultCompare(Class<?> type) {
        return type.isPrimitive() || Primitives.isWrapperType(type) || type == String.class || type == Class.class || type.isArray() && ReflectiveComparisonPerformer.isSuitableForDefaultCompare(type.getComponentType());
    }

    private ComparisonResult performPropertiesComparison(Object actual, Object expected) {
        LinkedHashMap<ClassPropertyKey, ComparisonResult> results = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        for (ClassProperty classProperty : this.fieldsExtractor.extractAll(actual.getClass()).values()) {
            if (classProperty.isStatic()) continue;
            results.put(classProperty.getKey(), this.performPropertyComparison(classProperty, actual, expected));
        }
        return new ComplexComparisonResult(actual, expected, this, results);
    }

    private ComparisonResult performPropertyComparison(ClassProperty property, Object actual, Object expected) {
        Object expectedValue;
        Object actualValue;
        try {
            actualValue = property.getValue(actual);
            expectedValue = property.getValue(expected);
        }
        catch (Throwable e) {
            return new ComparisonFail(actual, expected, this, e);
        }
        return this.apply(actualValue, expectedValue);
    }
}

