/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.comparison.performers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.whaka.util.reflection.comparison.ComparisonPerformer;
import org.whaka.util.reflection.comparison.ComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResult;
import org.whaka.util.reflection.comparison.ComplexComparisonResultBuilder;
import org.whaka.util.reflection.comparison.performers.ContainerComparisonPerformer;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class SetComparisonPerformer<T>
extends ContainerComparisonPerformer<T, Collection<? extends T>> {
    private static final ClassPropertyKey key = new ClassPropertyKey("contains", Collection.class);

    public SetComparisonPerformer(ComparisonPerformer<? super T> elementPerformer) {
        super(elementPerformer);
    }

    @Override
    public ComparisonResult apply(Collection<? extends T> actual, Collection<? extends T> expected) {
        if (actual == expected) {
            return new ComparisonResult(actual, expected, this, true);
        }
        if (actual == null || expected == null) {
            return new ComparisonResult(actual, expected, this, false);
        }
        if (actual.size() != expected.size()) {
            return this.createSizeCheckResult(actual, expected);
        }
        return this.performElementComparison(actual, expected);
    }

    private ComparisonResult createSizeCheckResult(Collection<? extends T> actual, Collection<? extends T> expected) {
        return new ComplexComparisonResultBuilder<Collection>(Collection.class).apply("size", actual.size(), expected.size()).build(actual, expected, this);
    }

    private ComparisonResult performElementComparison(Collection<? extends T> actual, Collection<? extends T> expected) {
        ArrayList<T> actualCopy = new ArrayList<T>(actual);
        for (T expectedElement : expected) {
            int matchedIndex = this.findMatchingIndex(expectedElement, actualCopy);
            if (matchedIndex < 0) {
                return this.createMissingElementResult(actual, expected, null, expectedElement);
            }
            actualCopy.remove(matchedIndex);
        }
        return new ComplexComparisonResult(actual, expected, this, Collections.emptyMap());
    }

    private int findMatchingIndex(T expectedElement, List<T> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!((ComparisonResult)this.getElementPerformer().apply((Object)list.get(i), (Object)expectedElement)).isSuccess()) continue;
            return i;
        }
        return -1;
    }

    private ComparisonResult createMissingElementResult(Collection<? extends T> actual, Collection<? extends T> expected, Object actualElement, Object expectedElement) {
        ComparisonResult result = new ComparisonResult(actualElement, expectedElement, this.getElementPerformer(), false);
        LinkedHashMap<ClassPropertyKey, ComparisonResult> results = new LinkedHashMap<ClassPropertyKey, ComparisonResult>();
        results.put(key, result);
        return new ComplexComparisonResult(actual, expected, this, results);
    }
}

